/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MarshallingException;
import org.freedesktop.dbus.exceptions.UnknownTypeCodeException;

public class Message {
    public static final byte PROTOCOL = 1;
    private static byte[][] padding = new byte[][]{null, new byte[1], new byte[2], new byte[3], new byte[4], new byte[5], new byte[6], new byte[7]};
    private static final int BUFFERINCREMENT = 20;
    private boolean big;
    protected byte[][] wiredata = new byte[20][];
    protected long bytecounter;
    protected Map<Byte, Object> headers = new HashMap<Byte, Object>();
    protected static long globalserial = 0L;
    protected long serial;
    protected byte type;
    protected byte flags;
    protected byte protover;
    private Object[] args;
    private byte[] body;
    private long bodylen = 0L;
    private int preallocated = 0;
    private int paofs = 0;
    private byte[] pabuf;
    private int bufferuse = 0;

    public static String getHeaderFieldName(byte field) {
        switch (field) {
            case 1: {
                return "Path";
            }
            case 2: {
                return "Interface";
            }
            case 3: {
                return "Member";
            }
            case 4: {
                return "Error Name";
            }
            case 5: {
                return "Reply Serial";
            }
            case 6: {
                return "Destination";
            }
            case 7: {
                return "Sender";
            }
            case 8: {
                return "Signature";
            }
        }
        return "Invalid";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message(byte endian, byte type, byte flags) throws DBusException {
        this.big = 66 == endian;
        this.bytecounter = 0L;
        Class<Message> clazz = Message.class;
        synchronized (Message.class) {
            this.serial = ++globalserial;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.type = type;
            this.flags = flags;
            this.preallocate(4);
            this.append("yyyy", endian, type, flags, (byte)1);
            return;
        }
    }

    protected Message() {
        this.bytecounter = 0L;
    }

    void populate(byte[] msg, byte[] headers, byte[] body) throws DBusException {
        this.big = msg[0] == 66;
        this.type = msg[1];
        this.flags = msg[2];
        this.protover = msg[3];
        this.wiredata[0] = msg;
        this.wiredata[1] = headers;
        this.wiredata[2] = body;
        this.body = body;
        this.bufferuse = 3;
        this.bodylen = ((Number)this.extract("u", msg, 4)[0]).longValue();
        this.serial = ((Number)this.extract("u", msg, 8)[0]).longValue();
        this.bytecounter = msg.length + headers.length + body.length;
        Object[] hs = this.extract("a(yv)", headers, 0);
        for (Object o : (Vector)hs[0]) {
            this.headers.put((Byte)((Object[])o)[0], ((Variant)((Object[])o)[1]).getValue());
        }
    }

    private void preallocate(int num) {
        this.preallocated = 0;
        this.pabuf = new byte[num];
        this.appendBytes(this.pabuf);
        this.preallocated = num;
        this.paofs = 0;
    }

    private void ensureBuffers(int num) {
        int increase = num - this.wiredata.length + this.bufferuse;
        if (increase > 0) {
            if (increase < 20) {
                increase = 20;
            }
            byte[][] temp = new byte[this.wiredata.length + increase][];
            System.arraycopy(this.wiredata, 0, temp, 0, this.wiredata.length);
            this.wiredata = temp;
        }
    }

    protected void appendBytes(byte[] buf) {
        if (null == buf) {
            return;
        }
        if (this.preallocated > 0) {
            if (this.paofs + buf.length > this.pabuf.length) {
                throw new ArrayIndexOutOfBoundsException(MessageFormat.format(Gettext.getString("arrayOutOfBounds"), this.paofs, this.pabuf.length, buf.length));
            }
            System.arraycopy(buf, 0, this.pabuf, this.paofs, buf.length);
            this.paofs += buf.length;
            this.preallocated -= buf.length;
        } else {
            if (this.bufferuse == this.wiredata.length) {
                byte[][] temp = new byte[this.wiredata.length + 20][];
                System.arraycopy(this.wiredata, 0, temp, 0, this.wiredata.length);
                this.wiredata = temp;
            }
            this.wiredata[this.bufferuse++] = buf;
            this.bytecounter += (long)buf.length;
        }
    }

    protected void appendByte(byte b) {
        if (this.preallocated > 0) {
            this.pabuf[this.paofs++] = b;
            --this.preallocated;
        } else {
            if (this.bufferuse == this.wiredata.length) {
                byte[][] temp = new byte[this.wiredata.length + 20][];
                System.arraycopy(this.wiredata, 0, temp, 0, this.wiredata.length);
                this.wiredata = temp;
            }
            this.wiredata[this.bufferuse++] = new byte[]{b};
            ++this.bytecounter;
        }
    }

    public long demarshallint(byte[] buf, int ofs, int width) {
        return this.big ? Message.demarshallintBig(buf, ofs, width) : Message.demarshallintLittle(buf, ofs, width);
    }

    public static long demarshallint(byte[] buf, int ofs, byte endian, int width) {
        return endian == 66 ? Message.demarshallintBig(buf, ofs, width) : Message.demarshallintLittle(buf, ofs, width);
    }

    public static long demarshallintBig(byte[] buf, int ofs, int width) {
        long l = 0L;
        for (int i = 0; i < width; ++i) {
            l <<= 8;
            l |= (long)(buf[ofs + i] & 0xFF);
        }
        return l;
    }

    public static long demarshallintLittle(byte[] buf, int ofs, int width) {
        long l = 0L;
        for (int i = width - 1; i >= 0; --i) {
            l <<= 8;
            l |= (long)(buf[ofs + i] & 0xFF);
        }
        return l;
    }

    public void appendint(long l, int width) {
        byte[] buf = new byte[width];
        this.marshallint(l, buf, 0, width);
        this.appendBytes(buf);
    }

    public void marshallint(long l, byte[] buf, int ofs, int width) {
        if (this.big) {
            Message.marshallintBig(l, buf, ofs, width);
        } else {
            Message.marshallintLittle(l, buf, ofs, width);
        }
    }

    public static void marshallintBig(long l, byte[] buf, int ofs, int width) {
        for (int i = width - 1; i >= 0; --i) {
            buf[i + ofs] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void marshallintLittle(long l, byte[] buf, int ofs, int width) {
        for (int i = 0; i < width; ++i) {
            buf[i + ofs] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public byte[][] getWireData() {
        return this.wiredata;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        sb.append(this.flags);
        sb.append(',');
        sb.append(this.serial);
        sb.append(')');
        sb.append(' ');
        sb.append('{');
        sb.append(' ');
        if (this.headers.size() == 0) {
            sb.append('}');
        } else {
            for (Byte field : this.headers.keySet()) {
                sb.append(Message.getHeaderFieldName(field));
                sb.append('=');
                sb.append('>');
                sb.append(this.headers.get(field).toString());
                sb.append(',');
                sb.append(' ');
            }
            sb.setCharAt(sb.length() - 2, ' ');
            sb.setCharAt(sb.length() - 1, '}');
        }
        sb.append(' ');
        sb.append('{');
        sb.append(' ');
        Object[] args = null;
        try {
            args = this.getParameters();
        }
        catch (DBusException DBe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
        }
        if (null == args || 0 == args.length) {
            sb.append('}');
        } else {
            for (Object o : args) {
                if (o instanceof Object[]) {
                    sb.append(Arrays.deepToString((Object[])o));
                } else if (o instanceof byte[]) {
                    sb.append(Arrays.toString((byte[])o));
                } else if (o instanceof int[]) {
                    sb.append(Arrays.toString((int[])o));
                } else if (o instanceof short[]) {
                    sb.append(Arrays.toString((short[])o));
                } else if (o instanceof long[]) {
                    sb.append(Arrays.toString((long[])o));
                } else if (o instanceof boolean[]) {
                    sb.append(Arrays.toString((boolean[])o));
                } else if (o instanceof double[]) {
                    sb.append(Arrays.toString((double[])o));
                } else if (o instanceof float[]) {
                    sb.append(Arrays.toString((float[])o));
                } else {
                    sb.append(o.toString());
                }
                sb.append(',');
                sb.append(' ');
            }
            sb.setCharAt(sb.length() - 2, ' ');
            sb.setCharAt(sb.length() - 1, '}');
        }
        return sb.toString();
    }

    public Object getHeader(byte type) {
        return this.headers.get(type);
    }

    private int appendone(byte[] sigb, int sigofs, Object data) throws DBusException {
        try {
            int i = sigofs;
            this.pad(sigb[i]);
            switch (sigb[i]) {
                case 121: {
                    this.appendByte(((Number)data).byteValue());
                    break;
                }
                case 98: {
                    this.appendint((Boolean)data != false ? 1L : 0L, 4);
                    break;
                }
                case 100: {
                    long l = Double.doubleToLongBits(((Number)data).doubleValue());
                    this.appendint(l, 8);
                    break;
                }
                case 102: {
                    int rf = Float.floatToIntBits(((Number)data).floatValue());
                    this.appendint(rf, 4);
                    break;
                }
                case 117: {
                    this.appendint(((Number)data).longValue(), 4);
                    break;
                }
                case 120: {
                    this.appendint(((Number)data).longValue(), 8);
                    break;
                }
                case 116: {
                    if (this.big) {
                        this.appendint(((UInt64)data).top(), 4);
                        this.appendint(((UInt64)data).bottom(), 4);
                        break;
                    }
                    this.appendint(((UInt64)data).bottom(), 4);
                    this.appendint(((UInt64)data).top(), 4);
                    break;
                }
                case 105: {
                    this.appendint(((Number)data).intValue(), 4);
                    break;
                }
                case 113: {
                    this.appendint(((Number)data).intValue(), 2);
                    break;
                }
                case 110: {
                    this.appendint(((Number)data).shortValue(), 2);
                    break;
                }
                case 111: 
                case 115: {
                    String payload = data.toString();
                    byte[] payloadbytes = null;
                    try {
                        payloadbytes = payload.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException UEe) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw new DBusException(Gettext.getString("utf8NotSupported"));
                    }
                    this.appendint(payloadbytes.length, 4);
                    this.appendBytes(payloadbytes);
                    this.appendBytes(padding[1]);
                    break;
                }
                case 103: {
                    String payload = data instanceof Type[] ? Marshalling.getDBusType((Type[])data) : (String)data;
                    byte[] pbytes = payload.getBytes();
                    this.preallocate(2 + pbytes.length);
                    this.appendByte((byte)pbytes.length);
                    this.appendBytes(pbytes);
                    this.appendByte((byte)0);
                    break;
                }
                case 97: {
                    byte[] alen = new byte[4];
                    this.appendBytes(alen);
                    this.pad(sigb[++i]);
                    long c = this.bytecounter;
                    if (data.getClass().isArray() && data.getClass().getComponentType().isPrimitive()) {
                        byte[] primbuf;
                        int algn = Message.getAlignment(sigb[i]);
                        int len = Array.getLength(data);
                        switch (sigb[i]) {
                            case 121: {
                                primbuf = (byte[])data;
                                break;
                            }
                            case 105: 
                            case 110: 
                            case 120: {
                                primbuf = new byte[len * algn];
                                int j = 0;
                                int k = 0;
                                while (j < len) {
                                    this.marshallint(Array.getLong(data, j), primbuf, k, algn);
                                    ++j;
                                    k += algn;
                                }
                                break;
                            }
                            case 98: {
                                primbuf = new byte[len * algn];
                                int j = 0;
                                int k = 0;
                                while (j < len) {
                                    this.marshallint(Array.getBoolean(data, j) ? 1L : 0L, primbuf, k, algn);
                                    ++j;
                                    k += algn;
                                }
                                break;
                            }
                            case 100: {
                                primbuf = new byte[len * algn];
                                if (data instanceof float[]) {
                                    int j = 0;
                                    int k = 0;
                                    while (j < len) {
                                        this.marshallint(Double.doubleToRawLongBits(((float[])data)[j]), primbuf, k, algn);
                                        ++j;
                                        k += algn;
                                    }
                                } else {
                                    int j = 0;
                                    int k = 0;
                                    while (j < len) {
                                        this.marshallint(Double.doubleToRawLongBits(((double[])data)[j]), primbuf, k, algn);
                                        ++j;
                                        k += algn;
                                    }
                                }
                                break;
                            }
                            case 102: {
                                primbuf = new byte[len * algn];
                                int j = 0;
                                int k = 0;
                                while (j < len) {
                                    this.marshallint(Float.floatToRawIntBits(((float[])data)[j]), primbuf, k, algn);
                                    ++j;
                                    k += algn;
                                }
                                break;
                            }
                            default: {
                                throw new MarshallingException(Gettext.getString("arraySentAsNonPrimitive"));
                            }
                        }
                        this.appendBytes(primbuf);
                    } else if (data instanceof List) {
                        Object[] contents = ((List)data).toArray();
                        int diff = i;
                        this.ensureBuffers(contents.length * 4);
                        for (Object o : contents) {
                            diff = this.appendone(sigb, i, o);
                        }
                        i = diff;
                    } else if (data instanceof Map) {
                        int diff = i;
                        this.ensureBuffers(((Map)data).size() * 6);
                        for (Map.Entry o : ((Map)data).entrySet()) {
                            diff = this.appendone(sigb, i, o);
                        }
                        if (i == diff) {
                            Vector<Type> temp = new Vector<Type>();
                            byte[] temp2 = new byte[sigb.length - diff];
                            System.arraycopy(sigb, diff, temp2, 0, temp2.length);
                            String temp3 = new String(temp2);
                            int temp4 = Marshalling.getJavaType(temp3, temp, 1);
                            diff += temp4;
                        }
                        i = diff;
                    } else {
                        Object[] contents = (Object[])data;
                        this.ensureBuffers(contents.length * 4);
                        int diff = i;
                        for (Object o : contents) {
                            diff = this.appendone(sigb, i, o);
                        }
                        i = diff;
                    }
                    this.marshallint(this.bytecounter - c, alen, 0, 4);
                    break;
                }
                case 40: {
                    Object[] contents = data instanceof Container ? ((Container)data).getParameters() : (Object[])data;
                    this.ensureBuffers(contents.length * 4);
                    int j = 0;
                    ++i;
                    while (sigb[i] != 41) {
                        i = this.appendone(sigb, i, contents[j++]);
                        ++i;
                    }
                    break;
                }
                case 123: {
                    if (data instanceof Map.Entry) {
                        ++i;
                        i = this.appendone(sigb, i, ((Map.Entry)data).getKey());
                        ++i;
                        i = this.appendone(sigb, i, ((Map.Entry)data).getValue());
                        ++i;
                        break;
                    }
                    Object[] contents = (Object[])data;
                    int j = 0;
                    ++i;
                    while (sigb[i] != 125) {
                        i = this.appendone(sigb, i, contents[j++]);
                        ++i;
                    }
                    break;
                }
                case 118: {
                    if (data instanceof Variant) {
                        Variant var = (Variant)data;
                        this.appendone(new byte[]{103}, 0, var.getSig());
                        this.appendone(var.getSig().getBytes(), 0, var.getValue());
                        break;
                    }
                    if (data instanceof Object[]) {
                        Object[] contents = (Object[])data;
                        this.appendone(new byte[]{103}, 0, contents[0]);
                        this.appendone(((String)contents[0]).getBytes(), 0, contents[1]);
                        break;
                    }
                    String sig = Marshalling.getDBusType(data.getClass())[0];
                    this.appendone(new byte[]{103}, 0, sig);
                    this.appendone(sig.getBytes(), 0, data);
                }
            }
            return i;
        }
        catch (ClassCastException CCe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new MarshallingException(MessageFormat.format(Gettext.getString("unconvertableType"), data.getClass().getName(), sigb[sigofs]));
        }
    }

    public void pad(byte type) {
        int a = Message.getAlignment(type);
        int b = (int)((this.bytecounter - (long)this.preallocated) % (long)a);
        if (0 == b) {
            return;
        }
        a -= b;
        if (this.preallocated > 0) {
            this.paofs += a;
            this.preallocated -= a;
        } else {
            this.appendBytes(padding[a]);
        }
    }

    public static int getAlignment(byte type) {
        switch (type) {
            case 2: 
            case 110: 
            case 113: {
                return 2;
            }
            case 4: 
            case 97: 
            case 98: 
            case 102: 
            case 105: 
            case 111: 
            case 115: 
            case 117: {
                return 4;
            }
            case 8: 
            case 40: 
            case 41: 
            case 100: 
            case 101: 
            case 114: 
            case 116: 
            case 120: 
            case 123: 
            case 125: {
                return 8;
            }
        }
        return 1;
    }

    public void append(String sig, Object ... data) throws DBusException {
        byte[] sigb = sig.getBytes();
        int j = 0;
        for (int i = 0; i < sigb.length; ++i) {
            i = this.appendone(sigb, i, data[j++]);
        }
    }

    public int align(int current, byte type) {
        int a = Message.getAlignment(type);
        if (0 == current % a) {
            return current;
        }
        return current + (a - current % a);
    }

    private Object extractone(byte[] sigb, byte[] buf, int[] ofs, boolean contained) throws DBusException {
        Object rv = null;
        ofs[1] = this.align(ofs[1], sigb[ofs[0]]);
        switch (sigb[ofs[0]]) {
            case 121: {
                int n = ofs[1];
                ofs[1] = n + 1;
                rv = buf[n];
                break;
            }
            case 117: {
                rv = new UInt32(this.demarshallint(buf, ofs[1], 4));
                ofs[1] = ofs[1] + 4;
                break;
            }
            case 105: {
                rv = (int)this.demarshallint(buf, ofs[1], 4);
                ofs[1] = ofs[1] + 4;
                break;
            }
            case 110: {
                rv = (short)this.demarshallint(buf, ofs[1], 2);
                ofs[1] = ofs[1] + 2;
                break;
            }
            case 113: {
                rv = new UInt16((int)this.demarshallint(buf, ofs[1], 2));
                ofs[1] = ofs[1] + 2;
                break;
            }
            case 120: {
                rv = this.demarshallint(buf, ofs[1], 8);
                ofs[1] = ofs[1] + 8;
                break;
            }
            case 116: {
                long bottom;
                long top;
                if (this.big) {
                    top = this.demarshallint(buf, ofs[1], 4);
                    ofs[1] = ofs[1] + 4;
                    bottom = this.demarshallint(buf, ofs[1], 4);
                } else {
                    bottom = this.demarshallint(buf, ofs[1], 4);
                    ofs[1] = ofs[1] + 4;
                    top = this.demarshallint(buf, ofs[1], 4);
                }
                rv = new UInt64(top, bottom);
                ofs[1] = ofs[1] + 4;
                break;
            }
            case 100: {
                long l = this.demarshallint(buf, ofs[1], 8);
                ofs[1] = ofs[1] + 8;
                rv = Double.longBitsToDouble(l);
                break;
            }
            case 102: {
                int rf = (int)this.demarshallint(buf, ofs[1], 4);
                ofs[1] = ofs[1] + 4;
                rv = Float.valueOf(Float.intBitsToFloat(rf));
                break;
            }
            case 98: {
                int rf = (int)this.demarshallint(buf, ofs[1], 4);
                ofs[1] = ofs[1] + 4;
                rv = 1 == rf ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 97: {
                long size = this.demarshallint(buf, ofs[1], 4);
                ofs[1] = ofs[1] + 4;
                ofs[0] = ofs[0] + 1;
                byte algn = (byte)Message.getAlignment(sigb[ofs[0]]);
                ofs[1] = this.align(ofs[1], sigb[ofs[0]]);
                int length = (int)(size / (long)algn);
                if (length > 0x4000000) {
                    throw new MarshallingException(Gettext.getString("arrayMustNotExceed") + 0x4000000);
                }
                switch (sigb[ofs[0]]) {
                    case 121: {
                        rv = new byte[length];
                        System.arraycopy(buf, ofs[1], rv, 0, length);
                        ofs[1] = (int)((long)ofs[1] + size);
                        break;
                    }
                    case 110: {
                        rv = new short[length];
                        for (int j = 0; j < length; ++j) {
                            ((short[])rv)[j] = (short)this.demarshallint(buf, ofs[1], algn);
                            ofs[1] = ofs[1] + algn;
                        }
                        break;
                    }
                    case 105: {
                        rv = new int[length];
                        for (int j = 0; j < length; ++j) {
                            ((int[])rv)[j] = (int)this.demarshallint(buf, ofs[1], algn);
                            ofs[1] = ofs[1] + algn;
                        }
                        break;
                    }
                    case 120: {
                        rv = new long[length];
                        for (int j = 0; j < length; ++j) {
                            ((long[])rv)[j] = this.demarshallint(buf, ofs[1], algn);
                            ofs[1] = ofs[1] + algn;
                        }
                        break;
                    }
                    case 98: {
                        rv = new boolean[length];
                        for (int j = 0; j < length; ++j) {
                            ((boolean[])rv)[j] = 1L == this.demarshallint(buf, ofs[1], algn);
                            ofs[1] = ofs[1] + algn;
                        }
                        break;
                    }
                    case 102: {
                        rv = new float[length];
                        for (int j = 0; j < length; ++j) {
                            ((float[])rv)[j] = Float.intBitsToFloat((int)this.demarshallint(buf, ofs[1], algn));
                            ofs[1] = ofs[1] + algn;
                        }
                        break;
                    }
                    case 100: {
                        rv = new double[length];
                        for (int j = 0; j < length; ++j) {
                            ((double[])rv)[j] = Double.longBitsToDouble(this.demarshallint(buf, ofs[1], algn));
                            ofs[1] = ofs[1] + algn;
                        }
                        break;
                    }
                    case 123: {
                        if (0L == size) {
                            Vector<Type> temp = new Vector<Type>();
                            byte[] temp2 = new byte[sigb.length - ofs[0]];
                            System.arraycopy(sigb, ofs[0], temp2, 0, temp2.length);
                            String temp3 = new String(temp2);
                            int temp4 = Marshalling.getJavaType(temp3, temp, 1) - 1;
                            ofs[0] = ofs[0] + temp4;
                        }
                        int ofssave = ofs[0];
                        long end = (long)ofs[1] + size;
                        Vector<Object[]> entries = new Vector<Object[]>();
                        while ((long)ofs[1] < end) {
                            ofs[0] = ofssave;
                            entries.add((Object[])this.extractone(sigb, buf, ofs, true));
                        }
                        rv = new DBusMap((Object[][])entries.toArray((T[])new Object[0][]));
                        break;
                    }
                    default: {
                        if (0L == size) {
                            Vector<Type> temp = new Vector<Type>();
                            byte[] temp2 = new byte[sigb.length - ofs[0]];
                            System.arraycopy(sigb, ofs[0], temp2, 0, temp2.length);
                            String temp3 = new String(temp2);
                            int temp4 = Marshalling.getJavaType(temp3, temp, 1) - 1;
                            ofs[0] = ofs[0] + temp4;
                        }
                        int ofssave = ofs[0];
                        long end = (long)ofs[1] + size;
                        Vector<Object> contents = new Vector<Object>();
                        while ((long)ofs[1] < end) {
                            ofs[0] = ofssave;
                            contents.add(this.extractone(sigb, buf, ofs, true));
                        }
                        rv = contents;
                    }
                }
                if (!contained || rv instanceof List || rv instanceof Map) break;
                rv = ArrayFrob.listify(rv);
                break;
            }
            case 40: {
                Vector<Object> contents = new Vector<Object>();
                while (sigb[ofs[0] = ofs[0] + 1] != 41) {
                    contents.add(this.extractone(sigb, buf, ofs, true));
                }
                rv = contents.toArray();
                break;
            }
            case 123: {
                Object[] decontents = new Object[2];
                ofs[0] = ofs[0] + 1;
                decontents[0] = this.extractone(sigb, buf, ofs, true);
                ofs[0] = ofs[0] + 1;
                decontents[1] = this.extractone(sigb, buf, ofs, true);
                ofs[0] = ofs[0] + 1;
                rv = decontents;
                break;
            }
            case 118: {
                int[] newofs = new int[]{0, ofs[1]};
                String sig = (String)this.extract("g", buf, newofs)[0];
                newofs[0] = 0;
                rv = new Variant<Object>(this.extract(sig, buf, newofs)[0], sig);
                ofs[1] = newofs[1];
                break;
            }
            case 115: {
                int length = (int)this.demarshallint(buf, ofs[1], 4);
                ofs[1] = ofs[1] + 4;
                try {
                    rv = new String(buf, ofs[1], length, "UTF-8");
                }
                catch (UnsupportedEncodingException UEe) {
                    if (AbstractConnection.EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    throw new DBusException(Gettext.getString("utf8NotSupported"));
                }
                ofs[1] = ofs[1] + (length + 1);
                break;
            }
            case 111: {
                int length = (int)this.demarshallint(buf, ofs[1], 4);
                ofs[1] = ofs[1] + 4;
                rv = new ObjectPath(this.getSource(), new String(buf, ofs[1], length));
                ofs[1] = ofs[1] + (length + 1);
                break;
            }
            case 103: {
                int n = ofs[1];
                ofs[1] = n + 1;
                int length = buf[n] & 0xFF;
                rv = new String(buf, ofs[1], length);
                ofs[1] = ofs[1] + (length + 1);
                break;
            }
            default: {
                throw new UnknownTypeCodeException(sigb[ofs[0]]);
            }
        }
        return rv;
    }

    public Object[] extract(String sig, byte[] buf, int ofs) throws DBusException {
        return this.extract(sig, buf, new int[]{0, ofs});
    }

    public Object[] extract(String sig, byte[] buf, int[] ofs) throws DBusException {
        Vector<Object> rv = new Vector<Object>();
        byte[] sigb = sig.getBytes();
        int[] i = ofs;
        while (i[0] < sigb.length) {
            rv.add(this.extractone(sigb, buf, i, false));
            i[0] = i[0] + 1;
        }
        return rv.toArray();
    }

    public String getSource() {
        return (String)this.headers.get((byte)7);
    }

    public String getDestination() {
        return (String)this.headers.get((byte)6);
    }

    public String getInterface() {
        return (String)this.headers.get((byte)2);
    }

    public String getPath() {
        Object o = this.headers.get((byte)1);
        if (null == o) {
            return null;
        }
        return o.toString();
    }

    public String getName() {
        if (this instanceof Error) {
            return (String)this.headers.get((byte)4);
        }
        return (String)this.headers.get((byte)3);
    }

    public String getSig() {
        return (String)this.headers.get((byte)8);
    }

    public int getFlags() {
        return this.flags;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getReplySerial() {
        Number l = (Number)this.headers.get((byte)5);
        if (null == l) {
            return 0L;
        }
        return l.longValue();
    }

    public Object[] getParameters() throws DBusException {
        if (null == this.args && null != this.body) {
            String sig = (String)this.headers.get((byte)8);
            this.args = null != sig && 0 != this.body.length ? this.extract(sig, this.body, 0) : new Object[0];
        }
        return this.args;
    }

    protected void setArgs(Object[] args) {
        this.args = args;
    }

    public void setSource(String source) throws DBusException {
        if (null != this.body) {
            this.wiredata = new byte[20][];
            this.bufferuse = 0;
            this.bytecounter = 0L;
            this.preallocate(12);
            this.append("yyyyuu", this.big ? (byte)66 : 108, this.type, this.flags, this.protover, this.bodylen, this.serial);
            this.headers.put((byte)7, source);
            Object[][] newhead = new Object[this.headers.size()][];
            int i = 0;
            for (Byte b : this.headers.keySet()) {
                newhead[i] = new Object[2];
                newhead[i][0] = b;
                newhead[i][1] = this.headers.get(b);
                ++i;
            }
            this.append("a(yv)", new Object[]{newhead});
            this.pad((byte)8);
            this.appendBytes(this.body);
        }
    }

    public static interface ArgumentType {
        public static final String BYTE_STRING = "y";
        public static final String BOOLEAN_STRING = "b";
        public static final String INT16_STRING = "n";
        public static final String UINT16_STRING = "q";
        public static final String INT32_STRING = "i";
        public static final String UINT32_STRING = "u";
        public static final String INT64_STRING = "x";
        public static final String UINT64_STRING = "t";
        public static final String DOUBLE_STRING = "d";
        public static final String FLOAT_STRING = "f";
        public static final String STRING_STRING = "s";
        public static final String OBJECT_PATH_STRING = "o";
        public static final String SIGNATURE_STRING = "g";
        public static final String ARRAY_STRING = "a";
        public static final String VARIANT_STRING = "v";
        public static final String STRUCT_STRING = "r";
        public static final String STRUCT1_STRING = "(";
        public static final String STRUCT2_STRING = ")";
        public static final String DICT_ENTRY_STRING = "e";
        public static final String DICT_ENTRY1_STRING = "{";
        public static final String DICT_ENTRY2_STRING = "}";
        public static final byte BYTE = 121;
        public static final byte BOOLEAN = 98;
        public static final byte INT16 = 110;
        public static final byte UINT16 = 113;
        public static final byte INT32 = 105;
        public static final byte UINT32 = 117;
        public static final byte INT64 = 120;
        public static final byte UINT64 = 116;
        public static final byte DOUBLE = 100;
        public static final byte FLOAT = 102;
        public static final byte STRING = 115;
        public static final byte OBJECT_PATH = 111;
        public static final byte SIGNATURE = 103;
        public static final byte ARRAY = 97;
        public static final byte VARIANT = 118;
        public static final byte STRUCT = 114;
        public static final byte STRUCT1 = 40;
        public static final byte STRUCT2 = 41;
        public static final byte DICT_ENTRY = 101;
        public static final byte DICT_ENTRY1 = 123;
        public static final byte DICT_ENTRY2 = 125;
    }

    public static interface HeaderField {
        public static final byte PATH = 1;
        public static final byte INTERFACE = 2;
        public static final byte MEMBER = 3;
        public static final byte ERROR_NAME = 4;
        public static final byte REPLY_SERIAL = 5;
        public static final byte DESTINATION = 6;
        public static final byte SENDER = 7;
        public static final byte SIGNATURE = 8;
    }

    public static interface MessageType {
        public static final byte METHOD_CALL = 1;
        public static final byte METHOD_RETURN = 2;
        public static final byte ERROR = 3;
        public static final byte SIGNAL = 4;
    }

    public static interface Flags {
        public static final byte NO_REPLY_EXPECTED = 1;
        public static final byte NO_AUTO_START = 2;
        public static final byte ASYNC = 64;
    }

    public static interface Endian {
        public static final byte BIG = 66;
        public static final byte LITTLE = 108;
    }
}

