/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.ScriptExecutionException;

public class InvocableScriptAdapter
implements Invocable {
    private final ScriptModel scriptModel;
    private final ScriptEngine scriptEngine;

    public InvocableScriptAdapter(ScriptModel scriptModel, ScriptEngine scriptEngine) {
        if (scriptModel == null) {
            throw new IllegalArgumentException("scriptModel must not be null");
        }
        if (scriptEngine == null) {
            throw new IllegalArgumentException("scriptEngine must not be null");
        }
        this.scriptModel = scriptModel;
        this.scriptEngine = this.loadScriptIntoEngine(scriptModel, scriptEngine);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptExecutionException {
        try {
            return this.getInvocableEngine().invokeMethod(thiz, name, args);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new ScriptExecutionException(this.scriptModel, e);
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptExecutionException {
        try {
            return this.getInvocableEngine().invokeFunction(name, args);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new ScriptExecutionException(this.scriptModel, e);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.getInvocableEngine().getInterface(clazz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clazz) {
        return this.getInvocableEngine().getInterface(thiz, clazz);
    }

    public boolean isDefined(String name) {
        Object candidate = this.scriptEngine.getContext().getAttribute(name);
        return candidate != null;
    }

    private ScriptEngine loadScriptIntoEngine(ScriptModel script, ScriptEngine engine) {
        try {
            engine.eval(script.getCode());
        }
        catch (ScriptException se) {
            throw new ScriptExecutionException(script, se);
        }
        return engine;
    }

    private Invocable getInvocableEngine() {
        return (Invocable)((Object)this.scriptEngine);
    }
}

