/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.authorization.infinispan.CachedPolicyStore;
import org.keycloak.models.authorization.infinispan.CachedResourceServerStore;
import org.keycloak.models.authorization.infinispan.CachedResourceStore;
import org.keycloak.models.authorization.infinispan.CachedScopeStore;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;

public class InfinispanStoreFactoryProvider
implements CachedStoreFactoryProvider {
    private final CacheTransaction transaction = new CacheTransaction();
    private final CachedResourceStore resourceStore;
    private final CachedScopeStore scopeStore;
    private final CachedPolicyStore policyStore;
    private ResourceServerStore resourceServerStore;

    public InfinispanStoreFactoryProvider(KeycloakSession session) {
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.transaction);
        StoreFactory delegate = (StoreFactory)session.getProvider(StoreFactory.class);
        this.resourceStore = new CachedResourceStore(session, this, this.transaction, delegate);
        this.resourceServerStore = new CachedResourceServerStore(session, this.transaction, delegate);
        this.scopeStore = new CachedScopeStore(session, this, this.transaction, delegate);
        this.policyStore = new CachedPolicyStore(session, this, this.transaction, delegate);
    }

    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public ResourceServerStore getResourceServerStore() {
        return this.resourceServerStore;
    }

    public ScopeStore getScopeStore() {
        return this.scopeStore;
    }

    public PolicyStore getPolicyStore() {
        return this.policyStore;
    }

    public void close() {
    }

    static class CacheTransaction
    implements KeycloakTransaction {
        private List<Runnable> completeTasks = new ArrayList<Runnable>();
        private List<Runnable> rollbackTasks = new ArrayList<Runnable>();

        CacheTransaction() {
        }

        public void begin() {
        }

        public void commit() {
            this.completeTasks.forEach(task -> task.run());
        }

        public void rollback() {
            this.rollbackTasks.forEach(task -> task.run());
        }

        public void setRollbackOnly() {
        }

        public boolean getRollbackOnly() {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        protected void whenCommit(Runnable task) {
            this.completeTasks.add(task);
        }

        protected void whenRollback(Runnable task) {
            this.rollbackTasks.add(task);
        }
    }
}

