/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.security.Key;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.common.util.PemUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.admin.AdminRoot;

public class PublicRealmResource {
    protected static final Logger logger = Logger.getLogger(PublicRealmResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    protected RealmModel realm;

    public PublicRealmResource(RealmModel realm) {
        this.realm = realm;
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public PublishedRealmRepresentation getRealm() {
        Cors.add(this.request).allowedOrigins("*").auth().build(this.response);
        return PublicRealmResource.realmRep(this.session, this.realm, this.uriInfo);
    }

    public static PublishedRealmRepresentation realmRep(KeycloakSession session, RealmModel realm, UriInfo uriInfo) {
        PublishedRealmRepresentation rep = new PublishedRealmRepresentation();
        rep.setRealm(realm.getName());
        rep.setTokenServiceUrl(OIDCLoginProtocolService.tokenServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setAccountServiceUrl(AccountService.accountServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setAdminApiUrl(uriInfo.getBaseUriBuilder().path(AdminRoot.class).build(new Object[0]).toString());
        rep.setPublicKeyPem(PemUtils.encodeKey((Key)session.keys().getActiveRsaKey(realm).getPublicKey()));
        rep.setNotBefore(realm.getNotBefore());
        return rep;
    }
}

