/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class PolicyUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String name;
    private static Set<String> resources;
    private Set<String> resourceTypes;
    private Set<String> scopes;
    private String serverId;

    public static PolicyUpdatedEvent create(String id, String name, Set<String> resources, Set<String> resourceTypes, Set<String> scopes, String serverId) {
        PolicyUpdatedEvent event = new PolicyUpdatedEvent();
        event.id = id;
        event.name = name;
        PolicyUpdatedEvent.resources = resources;
        event.resourceTypes = resourceTypes;
        event.scopes = scopes;
        event.serverId = serverId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("PolicyUpdatedEvent [ id=%s, name=%s ]", this.id, this.name);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.policyUpdated(this.id, this.name, resources, this.resourceTypes, this.scopes, this.serverId, invalidations);
    }
}

