/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class ResourceServerRemovedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String clientId;

    public static ResourceServerRemovedEvent create(String id, String clientId) {
        ResourceServerRemovedEvent event = new ResourceServerRemovedEvent();
        event.id = id;
        event.clientId = clientId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("ResourceServerRemovedEvent [ id=%s, clientId=%s ]", this.id, this.clientId);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.resourceServerRemoval(this.id, this.clientId, invalidations);
    }
}

