/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.GroupModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class GroupRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;
    private String parentId;
    private String realmId;

    public static GroupRemovedEvent create(GroupModel group, String realmId) {
        GroupRemovedEvent event = new GroupRemovedEvent();
        event.realmId = realmId;
        event.groupId = group.getId();
        event.parentId = group.getParentId();
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return String.format("GroupRemovedEvent [ realmId=%s, groupId=%s, parentId=%s ]", this.realmId, this.groupId, this.parentId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        if (this.parentId != null) {
            invalidations.add(this.parentId);
        }
    }
}

