/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class RealmRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String realmId;
    private String realmName;

    public static RealmRemovedEvent create(String realmId, String realmName) {
        RealmRemovedEvent event = new RealmRemovedEvent();
        event.realmId = realmId;
        event.realmName = realmName;
        return event;
    }

    @Override
    public String getId() {
        return this.realmId;
    }

    public String toString() {
        return String.format("RealmRemovedEvent [ realmId=%s, realmName=%s ]", this.realmId, this.realmName);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.realmRemoval(this.realmId, this.realmName, invalidations);
    }
}

