/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

public class UserUpdatedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;
    private String username;
    private String email;
    private String realmId;

    public static UserUpdatedEvent create(String userId, String username, String email, String realmId) {
        UserUpdatedEvent event = new UserUpdatedEvent();
        event.userId = userId;
        event.username = username;
        event.email = email;
        event.realmId = realmId;
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public String toString() {
        return String.format("UserUpdatedEvent [ userId=%s, username=%s, email=%s ]", this.userId, this.username, this.email);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.userUpdatedInvalidations(this.userId, this.username, this.email, this.realmId, invalidations);
    }
}

