/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission.evaluator;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.policy.evaluation.Result;

class IterablePermissionEvaluator
implements PermissionEvaluator {
    private final Iterator<ResourcePermission> permissions;
    private final EvaluationContext executionContext;
    private final PolicyEvaluator policyEvaluator;

    IterablePermissionEvaluator(Iterator<ResourcePermission> permissions, EvaluationContext executionContext, PolicyEvaluator policyEvaluator) {
        this.permissions = permissions;
        this.executionContext = executionContext;
        this.policyEvaluator = policyEvaluator;
    }

    @Override
    public void evaluate(Decision decision) {
        try {
            while (this.permissions.hasNext()) {
                this.policyEvaluator.evaluate(this.permissions.next(), this.executionContext, decision);
            }
            decision.onComplete();
        }
        catch (Throwable cause) {
            decision.onError(cause);
        }
    }

    @Override
    public List<Result> evaluate() {
        final AtomicReference result = new AtomicReference();
        this.evaluate(new DecisionResultCollector(){

            @Override
            public void onError(Throwable cause) {
                throw new RuntimeException("Failed to evaluate permissions", cause);
            }

            @Override
            protected void onComplete(List<Result> results) {
                result.set(results);
            }
        });
        return (List)result.get();
    }
}

