/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;

public class MigrateTo2_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.2.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo2_2_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            this.addIdentityProviderAuthenticator(realm);
        }
    }

    private void addIdentityProviderAuthenticator(RealmModel realm) {
        String defaultProvider = null;
        for (IdentityProviderModel provider : realm.getIdentityProviders()) {
            if (!provider.isEnabled() || !provider.isAuthenticateByDefault()) continue;
            defaultProvider = provider.getAlias();
            break;
        }
        DefaultAuthenticationFlows.addIdentityProviderAuthenticator(realm, defaultProvider);
    }
}

