/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import freemarker.template.utility.NullArgumentException;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.keycloak.services.ServicesLogger;

public abstract class UserIdentityExtractor {
    private static final ServicesLogger logger = ServicesLogger.LOGGER;

    public abstract Object extractUserIdentity(X509Certificate[] var1);

    public static UserIdentityExtractor getPatternIdentityExtractor(String pattern, Function<X509Certificate[], String> func) {
        return new PatternMatcher(pattern, func);
    }

    public static UserIdentityExtractor getX500NameExtractor(ASN1ObjectIdentifier identifier, Function<X509Certificate[], X500Name> x500Name) {
        return new X500NameRDNExtractor(identifier, x500Name);
    }

    public static OrBuilder either(UserIdentityExtractor extractor) {
        return new OrBuilder(extractor);
    }

    static class OrBuilder {
        UserIdentityExtractor extractor;
        UserIdentityExtractor other;

        OrBuilder(UserIdentityExtractor extractor) {
            this.extractor = extractor;
        }

        public UserIdentityExtractor or(UserIdentityExtractor other) {
            return new OrExtractor(this.extractor, other);
        }
    }

    static class PatternMatcher
    extends UserIdentityExtractor {
        private final String _pattern;
        private final Function<X509Certificate[], String> _f;

        PatternMatcher(String pattern, Function<X509Certificate[], String> valueToMatch) {
            this._pattern = pattern;
            this._f = valueToMatch;
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            String value = this._f.apply(certs);
            Pattern r = Pattern.compile(this._pattern, 2);
            Matcher m = r.matcher(value);
            if (!m.find()) {
                logger.debugf("[PatternMatcher:extract] No matches were found for input \"%s\", pattern=\"%s\"", value, this._pattern);
                return null;
            }
            if (m.groupCount() != 1) {
                logger.debugf("[PatternMatcher:extract] Match produced more than a single group for input \"%s\", pattern=\"%s\"", value, this._pattern);
                return null;
            }
            return m.group(1);
        }
    }

    static class X500NameRDNExtractor
    extends UserIdentityExtractor {
        private ASN1ObjectIdentifier x500NameStyle;
        Function<X509Certificate[], X500Name> x500Name;

        X500NameRDNExtractor(ASN1ObjectIdentifier x500NameStyle, Function<X509Certificate[], X500Name> x500Name) {
            this.x500NameStyle = x500NameStyle;
            this.x500Name = x500Name;
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            RDN[] rnds;
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            X500Name name = this.x500Name.apply(certs);
            if (name != null && (rnds = name.getRDNs(this.x500NameStyle)) != null && rnds.length > 0) {
                RDN cn = rnds[0];
                return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            }
            return null;
        }
    }

    static class OrExtractor
    extends UserIdentityExtractor {
        UserIdentityExtractor extractor;
        UserIdentityExtractor other;

        OrExtractor(UserIdentityExtractor extractor, UserIdentityExtractor other) {
            this.extractor = extractor;
            this.other = other;
            if (this.extractor == null) {
                throw new NullArgumentException("extractor");
            }
            if (this.other == null) {
                throw new NullArgumentException("other");
            }
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            Object result = this.extractor.extractUserIdentity(certs);
            if (result == null) {
                result = this.other.extractUserIdentity(certs);
            }
            return result;
        }
    }
}

