/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyResourceService;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.util.JsonSerialization;

public class PolicyTypeResourceService
extends PolicyResourceService {
    public PolicyTypeResourceService(Policy policy, ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        super(policy, resourceServer, authorization, auth, adminEvent);
    }

    @Override
    protected AbstractPolicyRepresentation doCreateRepresentation(String payload) {
        AbstractPolicyRepresentation representation;
        String type = this.getPolicy().getType();
        Class representationType = this.authorization.getProviderFactory(type).getRepresentationType();
        if (representationType == null) {
            throw new RuntimeException("Policy provider for type [" + type + "] returned a null representation type.");
        }
        try {
            representation = (AbstractPolicyRepresentation)JsonSerialization.readValue((String)payload, (Class)representationType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize JSON using policy provider for type [" + type + "].", e);
        }
        representation.setType(type);
        return representation;
    }

    @Override
    protected AbstractPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        PolicyProviderFactory providerFactory = authorization.getProviderFactory(policy.getType());
        return ModelToRepresentation.toRepresentation((Policy)policy, (Class)providerFactory.getRepresentationType(), (AuthorizationProvider)authorization);
    }
}

