/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import org.keycloak.protocol.oidc.utils.OIDCResponseType;

public enum OIDCResponseMode {
    QUERY,
    FRAGMENT,
    FORM_POST;


    public static OIDCResponseMode parse(String responseMode, OIDCResponseType responseType) {
        if (responseMode == null) {
            return OIDCResponseMode.getDefaultResponseMode(responseType);
        }
        return Enum.valueOf(OIDCResponseMode.class, responseMode.toUpperCase());
    }

    private static OIDCResponseMode getDefaultResponseMode(OIDCResponseType responseType) {
        if (responseType.isImplicitOrHybridFlow()) {
            return FRAGMENT;
        }
        return QUERY;
    }
}

