/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

class CodeGenerateUtil {
    private static final Logger logger = Logger.getLogger(CodeGenerateUtil.class);
    private static final Map<Class<? extends CommonClientSessionModel>, ClientSessionParser> PARSERS = new HashMap<Class<? extends CommonClientSessionModel>, ClientSessionParser>();

    CodeGenerateUtil() {
    }

    static <CS extends CommonClientSessionModel> ClientSessionParser<CS> getParser(Class<CS> clientSessionClass) {
        for (Class<? extends CommonClientSessionModel> c : PARSERS.keySet()) {
            if (!c.isAssignableFrom(clientSessionClass)) continue;
            return PARSERS.get(c);
        }
        return null;
    }

    static {
        PARSERS.put(AuthenticationSessionModel.class, new AuthenticationSessionModelParser());
        PARSERS.put(AuthenticatedClientSessionModel.class, new AuthenticatedClientSessionModelParser());
    }

    private static class AuthenticatedClientSessionModelParser
    implements ClientSessionParser<AuthenticatedClientSessionModel> {
        private AuthenticatedClientSessionModelParser() {
        }

        @Override
        public AuthenticatedClientSessionModel parseSession(String code, KeycloakSession session, RealmModel realm) {
            try {
                String[] parts = code.split("\\.");
                String userSessionId = parts[2];
                String clientUUID = parts[3];
                UserSessionModel userSession = session.sessions().getUserSession(realm, userSessionId);
                if (userSession == null) {
                    return null;
                }
                return (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(clientUUID);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public String generateCode(AuthenticatedClientSessionModel clientSession, String actionId) {
            String userSessionId = clientSession.getUserSession().getId();
            String clientUUID = clientSession.getClient().getId();
            StringBuilder sb = new StringBuilder();
            sb.append("uss.");
            sb.append(actionId);
            sb.append('.');
            sb.append(userSessionId);
            sb.append('.');
            sb.append(clientUUID);
            return sb.toString();
        }

        @Override
        public void removeExpiredSession(KeycloakSession session, AuthenticatedClientSessionModel clientSession) {
            throw new IllegalStateException("Not yet implemented");
        }

        @Override
        public String getNote(AuthenticatedClientSessionModel clientSession, String name) {
            return clientSession.getNote(name);
        }

        @Override
        public void removeNote(AuthenticatedClientSessionModel clientSession, String name) {
            clientSession.removeNote(name);
        }

        @Override
        public void setNote(AuthenticatedClientSessionModel clientSession, String name, String value) {
            clientSession.setNote(name, value);
        }
    }

    private static class AuthenticationSessionModelParser
    implements ClientSessionParser<AuthenticationSessionModel> {
        private AuthenticationSessionModelParser() {
        }

        @Override
        public AuthenticationSessionModel parseSession(String code, KeycloakSession session, RealmModel realm) {
            return new AuthenticationSessionManager(session).getCurrentAuthenticationSession(realm);
        }

        @Override
        public String generateCode(AuthenticationSessionModel clientSession, String actionId) {
            return actionId;
        }

        @Override
        public void removeExpiredSession(KeycloakSession session, AuthenticationSessionModel clientSession) {
            new AuthenticationSessionManager(session).removeAuthenticationSession(clientSession.getRealm(), clientSession, true);
        }

        @Override
        public String getNote(AuthenticationSessionModel clientSession, String name) {
            return clientSession.getAuthNote(name);
        }

        @Override
        public void removeNote(AuthenticationSessionModel clientSession, String name) {
            clientSession.removeAuthNote(name);
        }

        @Override
        public void setNote(AuthenticationSessionModel clientSession, String name, String value) {
            clientSession.setAuthNote(name, value);
        }
    }

    static interface ClientSessionParser<CS extends CommonClientSessionModel> {
        public CS parseSession(String var1, KeycloakSession var2, RealmModel var3);

        public String generateCode(CS var1, String var2);

        public void removeExpiredSession(KeycloakSession var1, CS var2);

        public String getNote(CS var1, String var2);

        public void removeNote(CS var1, String var2);

        public void setNote(CS var1, String var2, String var3);
    }
}

