/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.timer.ScheduledTask;

public class ScheduledTaskRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger(ScheduledTaskRunner.class);
    protected final KeycloakSessionFactory sessionFactory;
    protected final ScheduledTask task;

    public ScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task) {
        this.sessionFactory = sessionFactory;
        this.task = task;
    }

    @Override
    public void run() {
        KeycloakSession session = this.sessionFactory.create();
        try {
            this.runTask(session);
        }
        catch (Throwable t) {
            ServicesLogger.LOGGER.failedToRunScheduledTask(t, this.task.getClass().getSimpleName());
            session.getTransactionManager().rollback();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable t) {
                ServicesLogger.LOGGER.failedToCloseProviderSession(t);
            }
        }
    }

    protected void runTask(KeycloakSession session) {
        session.getTransactionManager().begin();
        this.task.run(session);
        session.getTransactionManager().commit();
        logger.debug((Object)("Executed scheduled task " + this.task.getClass().getSimpleName()));
    }
}

