/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.InsertGenerator;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;

public class InsertSetGenerator
extends AbstractSqlGenerator<InsertSetStatement> {
    private InsertGenerator myGenerator = new InsertGenerator();

    @Override
    public ValidationErrors validate(InsertSetStatement insertStatementSet, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", insertStatementSet.peek().getTableName());
        validationErrors.checkRequiredField("columns", insertStatementSet.peek().getColumnValues());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(InsertSetStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.peek() == null) {
            return new UnparsedSql[0];
        }
        StringBuffer sql = new StringBuffer();
        this.generateHeader(sql, statement, database);
        this.generateValues(sql, statement, database);
        return new Sql[]{new UnparsedSql(sql.toString(), this.getAffectedTable(statement))};
    }

    public void generateHeader(StringBuffer sql, InsertSetStatement statement, Database database) {
        InsertStatement insert = statement.peek();
        this.myGenerator.generateHeader(sql, insert, database);
    }

    public void generateValues(StringBuffer sql, InsertSetStatement statements, Database database) {
        int index = 0;
        for (InsertStatement statement : statements.getStatements()) {
            if (++index > statements.getBatchThreshold()) {
                sql.deleteCharAt(sql.lastIndexOf(","));
                sql.append(";\n");
                this.generateHeader(sql, statements, database);
                index = 0;
            }
            this.myGenerator.generateValues(sql, statement, database);
            sql.append(",");
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append(";");
    }

    protected Relation getAffectedTable(InsertSetStatement statement) {
        return new Table().setName(statement.getTableName()).setSchema(statement.getCatalogName(), statement.getSchemaName());
    }
}

