/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws.crypto;

import java.security.MessageDigest;
import java.util.Arrays;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jws.Algorithm;

public class HashProvider {
    public static String oidcHash(Algorithm jwtAlgorithm, String input) {
        byte[] digest = HashProvider.digest(jwtAlgorithm, input);
        int hashLength = digest.length / 2;
        byte[] hashInput = Arrays.copyOf(digest, hashLength);
        return Base64Url.encode(hashInput);
    }

    private static byte[] digest(Algorithm algorithm, String input) {
        String digestAlg = HashProvider.getJavaDigestAlgorithm(algorithm);
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlg);
            md.update(input.getBytes("UTF-8"));
            return md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getJavaDigestAlgorithm(Algorithm alg) {
        switch (alg) {
            case RS256: {
                return "SHA-256";
            }
            case RS384: {
                return "SHA-384";
            }
            case RS512: {
                return "SHA-512";
            }
        }
        throw new IllegalArgumentException("Not an RSA Algorithm");
    }
}

