/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class HardcodedLDAPRoleStorageMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(HardcodedLDAPRoleStorageMapper.class);
    public static final String ROLE = "role";

    public HardcodedLDAPRoleStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, final RealmModel realm) {
        return new UserModelDelegate(delegate){

            public Set<RoleModel> getRealmRoleMappings() {
                Set roles = super.getRealmRoleMappings();
                RoleModel role = HardcodedLDAPRoleStorageMapper.this.getRole(realm);
                if (role != null && role.getContainer().equals(realm)) {
                    roles.add(role);
                }
                return roles;
            }

            public Set<RoleModel> getClientRoleMappings(ClientModel app) {
                Set roles = super.getClientRoleMappings(app);
                RoleModel role = HardcodedLDAPRoleStorageMapper.this.getRole(realm);
                if (role != null && role.getContainer().equals(app)) {
                    roles.add(role);
                }
                return roles;
            }

            public boolean hasRole(RoleModel role) {
                return super.hasRole(role) || role.equals(HardcodedLDAPRoleStorageMapper.this.getRole(realm));
            }

            public Set<RoleModel> getRoleMappings() {
                Set roles = super.getRoleMappings();
                RoleModel role = HardcodedLDAPRoleStorageMapper.this.getRole(realm);
                if (role != null) {
                    roles.add(role);
                }
                return roles;
            }

            public void deleteRoleMapping(RoleModel role) {
                if (role.equals(HardcodedLDAPRoleStorageMapper.this.getRole(realm))) {
                    throw new ModelException("Not possible to delete role. It's hardcoded by LDAP mapper");
                }
                super.deleteRoleMapping(role);
            }
        };
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
    }

    private RoleModel getRole(RealmModel realm) {
        String roleName = (String)this.mapperModel.getConfig().getFirst((Object)ROLE);
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            logger.warnf("Hardcoded role '%s' configured in mapper '%s' is not available anymore", new Object[0]);
        }
        return role;
    }
}

