/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.aesh.EndpointTypeConverter;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.common.AttributeOperation;
import org.keycloak.client.registration.cli.common.CmdStdinContext;
import org.keycloak.client.registration.cli.common.EndpointType;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.util.AuthUtil;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.HttpUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.client.registration.cli.util.ParseUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;

@CommandDefinition(name="create", description="[ARGUMENTS]")
public class CreateCmd
extends AbstractAuthOptionsCmd
implements Command {
    @Option(shortName=105, name="clientId", description="After creation only print clientId to standard output", hasValue=false)
    protected boolean returnClientId = false;
    @Option(shortName=101, name="endpoint", description="Endpoint type / document format to use - one of: 'default', 'oidc', 'saml2'", hasValue=true, converter=EndpointTypeConverter.class)
    protected EndpointType regType;
    @Option(shortName=102, name="file", description="Read object from file or standard input if FILENAME is set to '-'", hasValue=true)
    protected String file;
    @Option(shortName=111, name="output", description="After creation output the new client configuration to standard output", hasValue=false)
    protected boolean outputClient = false;
    @Option(shortName=99, name="compressed", description="Don't pretty print the output", hasValue=false)
    protected boolean compressed = false;
    @Arguments
    protected List<String> args;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        LinkedList<AttributeOperation> attrs = new LinkedList<AttributeOperation>();
        try {
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            if (this.args != null) {
                Iterator<String> it = this.args.iterator();
                block16: while (it.hasNext()) {
                    String option;
                    switch (option = it.next()) {
                        case "-s": 
                        case "--set": {
                            if (!it.hasNext()) {
                                throw new IllegalArgumentException("Option " + option + " requires a value");
                            }
                            String[] keyVal = ParseUtil.parseKeyVal(it.next());
                            attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
                            continue block16;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported option: " + option);
                }
            }
            if (this.file == null && attrs.size() == 0) {
                throw new IllegalArgumentException("No file nor attribute values specified");
            }
            if (this.outputClient && this.returnClientId) {
                throw new IllegalArgumentException("Options -o and -i are mutually exclusive");
            }
            if ("-".equals(this.token)) {
                this.token = IoUtil.readSecret("Enter Initial Access Token: ", commandInvocation);
            }
            CmdStdinContext ctx = new CmdStdinContext();
            if (this.file != null) {
                ctx = ParseUtil.parseFileOrStdin(this.file, this.regType);
            }
            if (ctx.getEndpointType() == null) {
                this.regType = this.regType != null ? this.regType : EndpointType.DEFAULT;
                ctx.setEndpointType(this.regType);
            } else if (this.regType != null && ctx.getEndpointType() != this.regType) {
                throw new RuntimeException("Requested endpoint type not compatible with detected configuration format: " + (Object)((Object)ctx.getEndpointType()));
            }
            if (attrs.size() > 0) {
                ctx = ParseUtil.mergeAttributes(ctx, attrs);
            }
            String contentType = HttpUtil.getExpectedContentType(ctx.getEndpointType());
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            if (this.token == null) {
                this.token = config.sessionRealmConfigData().getInitialToken();
            }
            this.setupTruststore(config, commandInvocation);
            String auth = this.token;
            if (auth == null) {
                config = this.ensureAuthInfo(config, commandInvocation);
                if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                    auth = AuthUtil.ensureToken(config);
                }
            }
            auth = auth != null ? "Bearer " + auth : null;
            String server = config.getServerUrl();
            String realm = config.getRealm();
            InputStream response = HttpUtil.doPost(server + "/realms/" + realm + "/clients-registrations/" + ctx.getEndpointType().getEndpoint(), contentType, "application/json", ctx.getContent(), auth);
            try {
                Object client;
                if (ctx.getEndpointType() == EndpointType.DEFAULT || ctx.getEndpointType() == EndpointType.SAML2) {
                    client = JsonSerialization.readValue(response, ClientRepresentation.class);
                    this.outputResult(((ClientRepresentation)client).getClientId(), client);
                    ConfigUtil.saveMergeConfig(arg_0 -> CreateCmd.lambda$execute$0(server, realm, (ClientRepresentation)client, arg_0));
                } else if (ctx.getEndpointType() == EndpointType.OIDC) {
                    client = JsonSerialization.readValue(response, OIDCClientRepresentation.class);
                    this.outputResult(((OIDCClientRepresentation)client).getClientId(), client);
                    ConfigUtil.saveMergeConfig(arg_0 -> CreateCmd.lambda$execute$1(server, realm, (OIDCClientRepresentation)client, arg_0));
                } else {
                    IoUtil.printOut("Response from server: " + IoUtil.readFully(response));
                }
            }
            catch (UnrecognizedPropertyException e) {
                throw new RuntimeException("Failed to process HTTP reponse - " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process HTTP response", e);
            }
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    private void outputResult(String clientId, Object result) throws IOException {
        if (this.returnClientId) {
            IoUtil.printOut(clientId);
        } else if (this.outputClient) {
            if (this.compressed) {
                IoUtil.printOut(JsonSerialization.writeValueAsString(result));
            } else {
                IoUtil.printOut(JsonSerialization.writeValueAsPrettyString(result));
            }
        } else {
            IoUtil.printErr("Registered new client with client_id '" + clientId + "'");
        }
    }

    @Override
    protected boolean nothingToDo() {
        return this.noOptions() && this.regType == null && this.file == null && (this.args == null || this.args.size() == 0);
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help create' for more information";
    }

    @Override
    protected String help() {
        return CreateCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " create [ARGUMENTS]");
        out.println();
        out.println("Command to create new client configurations on the server. If Initial Access Token is specified (-t TOKEN)");
        out.println("or has previously been set for the server, and realm in the configuration ('" + OsUtil.CMD + " config initial-token'),");
        out.println("then that will be used, otherwise session access / refresh tokens will be used.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that does");
        out.println("                          not touch a config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    -t, --token TOKEN     Use the specified Initial Access Token for authorization or read it from standard input ");
        out.println("                          if '-' is specified. This overrides any token set by '" + OsUtil.CMD + " config initial-token'.");
        out.println("                          If not specified, session credentials are used - see: CREDENTIALS OPTIONS.");
        out.println("    -e, --endpoint TYPE   Endpoint type / document format to use - one of: 'default', 'oidc', 'saml2'.");
        out.println("                          If not specified, the format is deduced from input file or falls back to 'default'.");
        out.println("    -s, --set NAME=VALUE  Set a specific attribute NAME to a specified value VALUE");
        out.println("    -f, --file FILENAME   Read object from file or standard input if FILENAME is set to '-'");
        out.println("    -o, --output          After creation output the new client configuration to standard output");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println("    -i, --clientId        After creation only print clientId to standard output");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Create a new client using configuration read from standard input:");
        if (OsUtil.OS_ARCH.isWindows()) {
            out.println("  " + OsUtil.PROMPT + " echo { \"clientId\": \"my_client\" } | " + OsUtil.CMD + " create -f -");
        } else {
            out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " create -f - << EOF");
            out.println("  {");
            out.println("    \"clientId\": \"my_client\"");
            out.println("  }");
            out.println("  EOF");
        }
        out.println();
        out.println("Since we didn't specify an endpoint type it will be deduced from configuration format.");
        out.println("Supported formats include Keycloak default format, OIDC format, and SAML SP Metadata.");
        out.println();
        out.println("Creating a client using file as a template, and overriding some attributes:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " create -f my_client.json -s clientId=my_client2 -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]'");
        out.println();
        out.println("Creating a client using an Initial Access Token - you'll be prompted for a token:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " create -s clientId=my_client2 -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]' -t -");
        out.println();
        out.println("Creating a client using 'oidc' endpoint. Without setting endpoint type here it would be 'default':");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " create -e oidc -s 'redirect_uris=[\"http://localhost:8980/myapp/*\"]'");
        out.println();
        out.println("Creating a client using 'saml2' endpoint. In this case setting endpoint type is redundant since it is deduced ");
        out.println("from file content:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " create -e saml2 -f saml-sp-metadata.xml");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }

    private static /* synthetic */ void lambda$execute$1(String server, String realm, OIDCClientRepresentation client, ConfigData cfg) {
        ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken());
    }

    private static /* synthetic */ void lambda$execute$0(String server, String realm, ClientRepresentation client, ConfigData cfg) {
        ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken());
    }
}

