/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.verifyemail;

import java.util.Objects;
import javax.ws.rs.core.Response;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHander;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.verifyemail.VerifyEmailActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class VerifyEmailActionTokenHandler
extends AbstractActionTokenHander<VerifyEmailActionToken> {
    public VerifyEmailActionTokenHandler() {
        super("verify-email", VerifyEmailActionToken.class, "staleEmailVerificationLink", EventType.VERIFY_EMAIL, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super VerifyEmailActionToken>[] getVerifiers(ActionTokenContext<VerifyEmailActionToken> tokenContext) {
        return TokenUtils.predicates(TokenUtils.checkThat(t -> Objects.equals(t.getEmail(), tokenContext.getAuthenticationSession().getAuthenticatedUser().getEmail()), "invalid_email", this.getDefaultErrorMessage()));
    }

    @Override
    public Response handleToken(VerifyEmailActionToken token, ActionTokenContext<VerifyEmailActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        EventBuilder event = tokenContext.getEvent();
        event.event(EventType.VERIFY_EMAIL).detail("email", user.getEmail());
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        user.setEmailVerified(true);
        user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        authSession.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        event.success();
        if (tokenContext.isAuthenticationSessionFresh()) {
            AuthenticationSessionManager asm = new AuthenticationSessionManager(tokenContext.getSession());
            asm.removeAuthenticationSession(tokenContext.getRealm(), authSession, true);
            return ((LoginFormsProvider)tokenContext.getSession().getProvider(LoginFormsProvider.class)).setSuccess("emailVerifiedMessage", new Object[0]).createInfoPage();
        }
        tokenContext.setEvent(event.clone().removeDetail("email").event(EventType.LOGIN));
        String nextAction = AuthenticationManager.nextRequiredAction(tokenContext.getSession(), authSession, tokenContext.getClientConnection(), tokenContext.getRequest(), tokenContext.getUriInfo(), event);
        return AuthenticationManager.redirectToRequiredActions(tokenContext.getSession(), tokenContext.getRealm(), authSession, tokenContext.getUriInfo(), nextAction);
    }
}

