/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.aesh.cl.parser.AeshCommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.cl.validator.CommandValidator;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.container.AeshCommandContainer;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.util.ReflectionUtil;

public class CommandBuilder {
    private String name;
    private String description;
    private Command command;
    private CommandValidator<?> validator;
    private ResultHandler resultHandler;
    private ProcessedOption argument;
    private List<ProcessedOption> options;
    private List<CommandBuilder> children;
    private CommandLineParserException parserException;
    private CommandPopulator<?, ? extends Command> populator;
    private List<String> aliases;

    public CommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CommandBuilder aliases(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public CommandBuilder description(String description) {
        this.description = description;
        return this;
    }

    public CommandBuilder command(Command command) {
        this.command = command;
        return this;
    }

    public CommandBuilder command(Class<? extends Command> command) {
        this.command = ReflectionUtil.newInstance(command);
        return this;
    }

    public CommandBuilder validator(CommandValidator<?> commandValidator) {
        this.validator = commandValidator;
        return this;
    }

    public CommandBuilder validator(Class<? extends CommandValidator> commandValidator) {
        this.validator = ReflectionUtil.newInstance(commandValidator);
        return this;
    }

    public CommandBuilder populator(CommandPopulator<?, ? extends Command> populator) {
        this.populator = populator;
        return this;
    }

    public CommandBuilder resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public CommandBuilder resultHandler(Class<? extends ResultHandler> resultHandler) {
        this.resultHandler = ReflectionUtil.newInstance(resultHandler);
        return this;
    }

    public CommandBuilder argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public CommandBuilder addOption(ProcessedOption option) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        this.options.add(option);
        return this;
    }

    public CommandBuilder addOption(ProcessedOptionBuilder option) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        try {
            this.options.add(option.create());
        }
        catch (OptionParserException ope) {
            this.parserException = ope;
        }
        return this;
    }

    public CommandBuilder addOptions(List<ProcessedOption> options) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        this.options.addAll(options);
        return this;
    }

    public CommandBuilder addChild(CommandBuilder child) {
        if (this.children == null) {
            this.children = new ArrayList<CommandBuilder>();
        }
        this.children.add(child);
        return this;
    }

    public CommandBuilder addChildren(List<CommandBuilder> children) {
        if (this.children == null) {
            this.children = new ArrayList<CommandBuilder>();
        }
        this.children.addAll(children);
        return this;
    }

    public CommandContainer create() {
        try {
            if (this.parserException != null) {
                return new AeshCommandContainer(this.parserException.getMessage());
            }
            return new AeshCommandContainer(this.createParser());
        }
        catch (CommandLineParserException e) {
            return new AeshCommandContainer(e.getMessage());
        }
    }

    private AeshCommandLineParser createParser() throws CommandLineParserException {
        if (this.command == null) {
            throw new CommandLineParserException("Command object is null, cannot create command");
        }
        ProcessedCommand processedCommand = this.createProcessedCommand();
        AeshCommandLineParser parser = new AeshCommandLineParser(processedCommand);
        if (this.children != null) {
            for (CommandBuilder builder : this.children) {
                parser.addChildParser(builder.createParser());
            }
        }
        return parser;
    }

    private ProcessedCommand createProcessedCommand() throws CommandLineParserException {
        return new ProcessedCommandBuilder().name(this.name).aliases(this.aliases).command(this.command).description(this.description).addOptions(this.options).resultHandler(this.resultHandler).validator(this.validator).argument(this.argument).populator(this.populator).create();
    }
}

