/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.AuthenticationSessionProviderFactory;

public class InfinispanAuthenticationSessionProviderFactory
implements AuthenticationSessionProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanAuthenticationSessionProviderFactory.class);
    private volatile Cache<String, AuthenticationSessionEntity> authSessionsCache;
    public static final String AUTHENTICATION_SESSION_EVENTS = "AUTHENTICATION_SESSION_EVENTS";

    public void init(Config.Scope config) {
    }

    public AuthenticationSessionProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanAuthenticationSessionProvider(session, this.authSessionsCache);
    }

    private void updateAuthNotes(ClusterEvent clEvent) {
        if (!(clEvent instanceof AuthenticationSessionAuthNoteUpdateEvent)) {
            return;
        }
        AuthenticationSessionAuthNoteUpdateEvent event = (AuthenticationSessionAuthNoteUpdateEvent)clEvent;
        AuthenticationSessionEntity authSession = (AuthenticationSessionEntity)this.authSessionsCache.get((Object)event.getAuthSessionId());
        InfinispanAuthenticationSessionProviderFactory.updateAuthSession(authSession, event.getAuthNotesFragment());
    }

    private static void updateAuthSession(AuthenticationSessionEntity authSession, Map<String, String> authNotesFragment) {
        if (authSession != null) {
            if (authSession.getAuthNotes() == null) {
                authSession.setAuthNotes(new ConcurrentHashMap<String, String>());
            }
            for (Map.Entry<String, String> me : authNotesFragment.entrySet()) {
                String value = me.getValue();
                if (value == null) {
                    authSession.getAuthNotes().remove(me.getKey());
                    continue;
                }
                authSession.getAuthNotes().put(me.getKey(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.authSessionsCache == null) {
            InfinispanAuthenticationSessionProviderFactory infinispanAuthenticationSessionProviderFactory = this;
            synchronized (infinispanAuthenticationSessionProviderFactory) {
                if (this.authSessionsCache == null) {
                    InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                    this.authSessionsCache = connections.getCache("authenticationSessions");
                    ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
                    cluster.registerListener(AUTHENTICATION_SESSION_EVENTS, this::updateAuthNotes);
                    log.debugf("[%s] Registered cluster listeners", (Object)this.authSessionsCache.getCacheManager().getAddress());
                }
            }
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

