/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.keycloak.models.sessions.infinispan.UserSessionTimestamp;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class Mappers {
    public static Function<Map.Entry<String, Optional<UserSessionTimestamp>>, UserSessionTimestamp> userSessionTimestamp() {
        return new UserSessionTimestampMapper();
    }

    public static Function<Map.Entry<String, SessionEntity>, String> sessionId() {
        return new SessionIdMapper();
    }

    public static Function<Map.Entry<String, SessionEntity>, SessionEntity> sessionEntity() {
        return new SessionEntityMapper();
    }

    public static Function<Map.Entry<String, SessionEntity>, UserSessionEntity> userSessionEntity() {
        return new UserSessionEntityMapper();
    }

    public static Function<Map.Entry<LoginFailureKey, LoginFailureEntity>, LoginFailureKey> loginFailureId() {
        return new LoginFailureIdMapper();
    }

    private static class LoginFailureIdMapper
    implements Function<Map.Entry<LoginFailureKey, LoginFailureEntity>, LoginFailureKey>,
    Serializable {
        private LoginFailureIdMapper() {
        }

        @Override
        public LoginFailureKey apply(Map.Entry<LoginFailureKey, LoginFailureEntity> entry) {
            return entry.getKey();
        }
    }

    private static class UserSessionEntityMapper
    implements Function<Map.Entry<String, SessionEntity>, UserSessionEntity>,
    Serializable {
        private UserSessionEntityMapper() {
        }

        @Override
        public UserSessionEntity apply(Map.Entry<String, SessionEntity> entry) {
            return (UserSessionEntity)entry.getValue();
        }
    }

    private static class SessionEntityMapper
    implements Function<Map.Entry<String, SessionEntity>, SessionEntity>,
    Serializable {
        private SessionEntityMapper() {
        }

        @Override
        public SessionEntity apply(Map.Entry<String, SessionEntity> entry) {
            return entry.getValue();
        }
    }

    private static class SessionIdMapper
    implements Function<Map.Entry<String, SessionEntity>, String>,
    Serializable {
        private SessionIdMapper() {
        }

        @Override
        public String apply(Map.Entry<String, SessionEntity> entry) {
            return entry.getKey();
        }
    }

    private static class UserSessionTimestampMapper
    implements Function<Map.Entry<String, Optional<UserSessionTimestamp>>, UserSessionTimestamp>,
    Serializable {
        private UserSessionTimestampMapper() {
        }

        @Override
        public UserSessionTimestamp apply(Map.Entry<String, Optional<UserSessionTimestamp>> e) {
            return e.getValue().get();
        }
    }
}

