/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import java.util.Map;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class ClientModelIdentity
implements Identity {
    protected RealmModel realm;
    protected ClientModel client;
    protected UserModel serviceAccount;

    public ClientModelIdentity(KeycloakSession session, ClientModel client) {
        this.realm = client.getRealm();
        this.client = client;
        this.serviceAccount = session.users().getServiceAccount(client);
    }

    public String getId() {
        return this.client.getId();
    }

    public Attributes getAttributes() {
        MultivaluedHashMap map = new MultivaluedHashMap();
        if (this.serviceAccount != null) {
            map.addAll((Object)this.serviceAccount.getAttributes(), new Object[0]);
        }
        return Attributes.from((Map)map);
    }

    public boolean hasRealmRole(String roleName) {
        if (this.serviceAccount == null) {
            return false;
        }
        RoleModel role = this.realm.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.serviceAccount.hasRole(role);
    }

    public boolean hasClientRole(String clientId, String roleName) {
        if (this.serviceAccount == null) {
            return false;
        }
        ClientModel client = this.realm.getClientByClientId(clientId);
        RoleModel role = client.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.serviceAccount.hasRole(role);
    }

    public boolean hasRole(String roleName) {
        throw new RuntimeException("Should not execute");
    }

    public boolean hasClientRole(String roleName) {
        throw new RuntimeException("Should not execute");
    }
}

