/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.keycloak.protocol.oidc.OIDCWellKnownProvider;

public class Configuration {
    private static final String UMA_VERSION = "1.0";
    private static final List<String> DEFAULT_TOKEN_PROFILES = Arrays.asList("bearer");
    private String realmPublicKey;
    private String version;
    private URI issuer;
    @JsonProperty(value="pat_profiles_supported")
    private List<String> patProfiles;
    @JsonProperty(value="pat_grant_types_supported")
    private List<String> patGrantTypes;
    @JsonProperty(value="aat_profiles_supported")
    private List<String> aatProfiles;
    @JsonProperty(value="aat_grant_types_supported")
    private List<String> aatGrantTypes;
    @JsonProperty(value="rpt_profiles_supported")
    private List<String> rptProfiles;
    @JsonProperty(value="claim_token_profiles_supported")
    private List<String> claimTokenProfiles;
    @JsonProperty(value="dynamic_client_endpoint")
    private URI dynamicClientEndpoint;
    @JsonProperty(value="token_endpoint")
    private URI tokenEndpoint;
    @JsonProperty(value="authorization_endpoint")
    private URI authorizationEndpoint;
    @JsonProperty(value="requesting_party_claims_endpoint")
    private URI requestingPartyClaimsEndpoint;
    @JsonProperty(value="resource_set_registration_endpoint")
    private URI resourceSetRegistrationEndpoint;
    @JsonProperty(value="introspection_endpoint")
    private URI introspectionEndpoint;
    @JsonProperty(value="permission_registration_endpoint")
    private URI permissionRegistrationEndpoint;
    @JsonProperty(value="rpt_endpoint")
    private URI rptEndpoint;
    private String realm;
    private URI serverUrl;

    public static final Configuration fromDefault(String authzServerUri, String realm, URI authorizationEndpoint, URI tokenEndpoint, String publicKeyPem) {
        Configuration configuration = new Configuration();
        if (authzServerUri.endsWith("/")) {
            authzServerUri = authzServerUri.substring(0, authzServerUri.lastIndexOf("/"));
        }
        configuration.setVersion(UMA_VERSION);
        configuration.setIssuer(URI.create(authzServerUri));
        configuration.setPatProfiles(DEFAULT_TOKEN_PROFILES);
        configuration.setAatProfiles(DEFAULT_TOKEN_PROFILES);
        configuration.setRptProfiles(DEFAULT_TOKEN_PROFILES);
        configuration.setPatGrantTypes(OIDCWellKnownProvider.DEFAULT_GRANT_TYPES_SUPPORTED);
        configuration.setAatGrantTypes(OIDCWellKnownProvider.DEFAULT_GRANT_TYPES_SUPPORTED);
        configuration.setTokenEndpoint(tokenEndpoint);
        configuration.setAuthorizationEndpoint(authorizationEndpoint);
        configuration.setResourceSetRegistrationEndpoint(URI.create(authzServerUri + "/authz/protection/resource_set"));
        configuration.setPermissionRegistrationEndpoint(URI.create(authzServerUri + "/authz/protection/permission"));
        configuration.setRptEndpoint(URI.create(authzServerUri + "/authz/authorize"));
        configuration.setRealmPublicKey(publicKeyPem);
        configuration.setServerUrl(URI.create(authzServerUri));
        configuration.setRealm(realm);
        return configuration;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    void setIssuer(URI issuer) {
        this.issuer = issuer;
    }

    public List<String> getPatProfiles() {
        return this.patProfiles;
    }

    void setPatProfiles(List<String> patProfiles) {
        this.patProfiles = patProfiles;
    }

    public List<String> getPatGrantTypes() {
        return this.patGrantTypes;
    }

    void setPatGrantTypes(List<String> patGrantTypes) {
        this.patGrantTypes = patGrantTypes;
    }

    public List<String> getAatProfiles() {
        return this.aatProfiles;
    }

    void setAatProfiles(List<String> aatProfiles) {
        this.aatProfiles = aatProfiles;
    }

    public List<String> getAatGrantTypes() {
        return this.aatGrantTypes;
    }

    void setAatGrantTypes(List<String> aatGrantTypes) {
        this.aatGrantTypes = aatGrantTypes;
    }

    public List<String> getRptProfiles() {
        return this.rptProfiles;
    }

    void setRptProfiles(List<String> rptProfiles) {
        this.rptProfiles = rptProfiles;
    }

    public List<String> getClaimTokenProfiles() {
        return this.claimTokenProfiles;
    }

    void setClaimTokenProfiles(List<String> claimTokenProfiles) {
        this.claimTokenProfiles = claimTokenProfiles;
    }

    public URI getDynamicClientEndpoint() {
        return this.dynamicClientEndpoint;
    }

    void setDynamicClientEndpoint(URI dynamicClientEndpoint) {
        this.dynamicClientEndpoint = dynamicClientEndpoint;
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    void setTokenEndpoint(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    void setAuthorizationEndpoint(URI authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public URI getRequestingPartyClaimsEndpoint() {
        return this.requestingPartyClaimsEndpoint;
    }

    void setRequestingPartyClaimsEndpoint(URI requestingPartyClaimsEndpoint) {
        this.requestingPartyClaimsEndpoint = requestingPartyClaimsEndpoint;
    }

    public URI getResourceSetRegistrationEndpoint() {
        return this.resourceSetRegistrationEndpoint;
    }

    void setResourceSetRegistrationEndpoint(URI resourceSetRegistrationEndpoint) {
        this.resourceSetRegistrationEndpoint = resourceSetRegistrationEndpoint;
    }

    public URI getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    void setIntrospectionEndpoint(URI introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public URI getPermissionRegistrationEndpoint() {
        return this.permissionRegistrationEndpoint;
    }

    void setPermissionRegistrationEndpoint(URI permissionRegistrationEndpoint) {
        this.permissionRegistrationEndpoint = permissionRegistrationEndpoint;
    }

    public URI getRptEndpoint() {
        return this.rptEndpoint;
    }

    void setRptEndpoint(URI rptEndpoint) {
        this.rptEndpoint = rptEndpoint;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public URI getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(URI serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setRealmPublicKey(String realmPublicKey) {
        this.realmPublicKey = realmPublicKey;
    }

    public String getRealmPublicKey() {
        return this.realmPublicKey;
    }
}

