/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@SerializeWith(value=ExternalizerImpl.class)
public class SessionEntityWrapper<S extends SessionEntity> {
    private UUID version;
    private final S entity;
    private final Map<String, String> localMetadata;

    protected SessionEntityWrapper(UUID version, Map<String, String> localMetadata, S entity) {
        if (version == null) {
            throw new IllegalArgumentException("Version UUID can't be null");
        }
        this.version = version;
        this.localMetadata = localMetadata;
        this.entity = entity;
    }

    public SessionEntityWrapper(Map<String, String> localMetadata, S entity) {
        this(UUID.randomUUID(), localMetadata, entity);
    }

    public SessionEntityWrapper(S entity) {
        this(new ConcurrentHashMap<String, String>(), entity);
    }

    public UUID getVersion() {
        return this.version;
    }

    public void setVersion(UUID version) {
        this.version = version;
    }

    public S getEntity() {
        return this.entity;
    }

    public String getLocalMetadataNote(String key) {
        return this.localMetadata.get(key);
    }

    public void putLocalMetadataNote(String key, String value) {
        this.localMetadata.put(key, value);
    }

    public Integer getLocalMetadataNoteInt(String key) {
        String note = this.getLocalMetadataNote(key);
        return note == null ? null : Integer.valueOf(Integer.parseInt(note));
    }

    public void putLocalMetadataNoteInt(String key, int value) {
        this.localMetadata.put(key, String.valueOf(value));
    }

    public Map<String, String> getLocalMetadata() {
        return this.localMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionEntityWrapper)) {
            return false;
        }
        SessionEntityWrapper that = (SessionEntityWrapper)o;
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hashCode(this.version) * 17 + Objects.hashCode(this.entity);
    }

    public String toString() {
        return "SessionEntityWrapper{version=" + this.version + ", entity=" + this.entity + ", localMetadata=" + this.localMetadata + '}';
    }

    public static class ExternalizerImpl
    implements Externalizer<SessionEntityWrapper> {
        public void writeObject(ObjectOutput output, SessionEntityWrapper obj) throws IOException {
            MarshallUtil.marshallUUID((UUID)obj.version, (ObjectOutput)output, (boolean)false);
            MarshallUtil.marshallMap((Map)obj.localMetadata, (ObjectOutput)output);
            output.writeObject(obj.getEntity());
        }

        public SessionEntityWrapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            UUID objVersion = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false);
            Map localMetadata = MarshallUtil.unmarshallMap((ObjectInput)input, (MarshallUtil.MapBuilder)new MarshallUtil.MapBuilder<String, String, Map<String, String>>(){

                public Map<String, String> build(int size) {
                    return new ConcurrentHashMap<String, String>(size);
                }
            });
            SessionEntity entity = (SessionEntity)input.readObject();
            return new SessionEntityWrapper<SessionEntity>(objVersion, localMetadata, entity);
        }
    }
}

