/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.Time;
import org.keycloak.keys.RsaKeyMetadata;
import org.keycloak.keys.RsaKeyProvider;

public class FailsafeRsaKeyProvider
implements RsaKeyProvider {
    private static final Logger logger = Logger.getLogger(FailsafeRsaKeyProvider.class);
    private static String KID;
    private static KeyPair KEY_PAIR;
    private static long EXPIRES;
    private KeyPair keyPair;
    private String kid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailsafeRsaKeyProvider() {
        logger.errorv("No active keys found, using failsafe provider, please login to admin console to add keys. Clustering is not supported.", new Object[0]);
        Class<FailsafeRsaKeyProvider> clazz = FailsafeRsaKeyProvider.class;
        synchronized (FailsafeRsaKeyProvider.class) {
            if (EXPIRES < (long)Time.currentTime()) {
                KEY_PAIR = KeyUtils.generateRsaKeyPair((int)2048);
                KID = KeyUtils.createKeyId((Key)KEY_PAIR.getPublic());
                EXPIRES = Time.currentTime() + 600;
                if (EXPIRES > 0L) {
                    logger.warnv("Keys expired, re-generated kid={0}", (Object)KID);
                }
            }
            this.kid = KID;
            this.keyPair = KEY_PAIR;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getKid() {
        return this.kid;
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public PublicKey getPublicKey(String kid) {
        return kid.equals(this.kid) ? this.keyPair.getPublic() : null;
    }

    public X509Certificate getCertificate(String kid) {
        return null;
    }

    public List<RsaKeyMetadata> getKeyMetadata() {
        return Collections.emptyList();
    }

    public void close() {
    }
}

