/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.gitlab;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;

public class GitLabIdentityProvider
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    public static final String AUTH_URL = "https://gitlab.com/oauth/authorize";
    public static final String TOKEN_URL = "https://gitlab.com/oauth/token";
    public static final String USER_INFO = "https://gitlab.com/api/v4/user";
    public static final String API_SCOPE = "api";

    public GitLabIdentityProvider(KeycloakSession session, OIDCIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(USER_INFO);
        String defaultScope = config.getDefaultScope();
        if (defaultScope.equals("openid")) {
            config.setDefaultScope(("api " + defaultScope).trim());
        }
    }

    @Override
    protected BrokeredIdentityContext extractIdentity(AccessTokenResponse tokenResponse, String accessToken, JsonWebToken idToken) throws IOException {
        String userInfoUrl;
        String id = idToken.getSubject();
        BrokeredIdentityContext identity = new BrokeredIdentityContext(id);
        String name = (String)idToken.getOtherClaims().get("name");
        String preferredUsername = (String)idToken.getOtherClaims().get("nickname");
        String email = (String)idToken.getOtherClaims().get("email");
        if (((OIDCIdentityProviderConfig)this.getConfig()).getDefaultScope().contains(API_SCOPE) && (userInfoUrl = this.getUserInfoUrl()) != null && !userInfoUrl.isEmpty() && (id == null || name == null || preferredUsername == null || email == null)) {
            JsonNode userInfo = SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asJson();
            name = this.getJsonProperty(userInfo, "name");
            preferredUsername = this.getJsonProperty(userInfo, "username");
            email = this.getJsonProperty(userInfo, "email");
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(identity, userInfo, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
        }
        identity.getContextData().put("FEDERATED_ACCESS_TOKEN_RESPONSE", tokenResponse);
        identity.getContextData().put("VALIDATED_ID_TOKEN", idToken);
        this.processAccessTokenResponse(identity, tokenResponse);
        identity.setId(id);
        identity.setName(name);
        identity.setEmail(email);
        identity.setBrokerUserId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + id);
        if (tokenResponse.getSessionState() != null) {
            identity.setBrokerSessionId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + tokenResponse.getSessionState());
        }
        if (preferredUsername == null) {
            preferredUsername = email;
        }
        if (preferredUsername == null) {
            preferredUsername = id;
        }
        identity.setUsername(preferredUsername);
        return identity;
    }
}

