/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class MigrateTo3_3_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("3.3.0");

    @Override
    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            Map securityHeaders = realm.getBrowserSecurityHeaders();
            if (securityHeaders == null || !securityHeaders.containsValue("frame-src 'self';")) continue;
            HashMap<String, String> browserSecurityHeaders = new HashMap<String, String>(securityHeaders);
            browserSecurityHeaders.put("contentSecurityPolicy", "frame-src 'self'; frame-ancestors 'self'; object-src 'none';");
            realm.setBrowserSecurityHeaders(Collections.unmodifiableMap(browserSecurityHeaders));
        }
    }

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }
}

