/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.CodeGenerateUtil;
import org.keycloak.sessions.CommonClientSessionModel;

public class ClientSessionCode<CLIENT_SESSION extends CommonClientSessionModel> {
    private static final String ACTIVE_CODE = "active_code";
    private static final Logger logger = Logger.getLogger(ClientSessionCode.class);
    private KeycloakSession session;
    private final RealmModel realm;
    private final CLIENT_SESSION commonLoginSession;

    public ClientSessionCode(KeycloakSession session, RealmModel realm, CLIENT_SESSION commonLoginSession) {
        this.session = session;
        this.realm = realm;
        this.commonLoginSession = commonLoginSession;
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> ParseResult<CLIENT_SESSION> parseResult(String code, KeycloakSession session, RealmModel realm, Class<CLIENT_SESSION> sessionClass) {
        ParseResult result = new ParseResult();
        if (code == null) {
            result.illegalHash = true;
            return result;
        }
        try {
            result.clientSession = ClientSessionCode.getClientSession(code, session, realm, sessionClass);
            if (result.clientSession == null) {
                result.authSessionNotFound = true;
                return result;
            }
            if (!ClientSessionCode.verifyCode(code, result.clientSession)) {
                result.illegalHash = true;
                return result;
            }
            result.code = new ClientSessionCode(session, realm, result.clientSession);
            return result;
        }
        catch (RuntimeException e) {
            result.illegalHash = true;
            return result;
        }
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> CLIENT_SESSION getClientSession(String code, KeycloakSession session, RealmModel realm, Class<CLIENT_SESSION> sessionClass) {
        CLIENT_SESSION clientSessionn = CodeGenerateUtil.getParser(sessionClass).parseSession(code, session, realm);
        CommonClientSessionModel clientSession = (CommonClientSessionModel)sessionClass.cast(clientSessionn);
        return (CLIENT_SESSION)clientSession;
    }

    public CLIENT_SESSION getClientSession() {
        return this.commonLoginSession;
    }

    public boolean isValid(String requestedAction, ActionType actionType) {
        if (!this.isValidAction(requestedAction)) {
            return false;
        }
        return this.isActionActive(actionType);
    }

    public boolean isActionActive(ActionType actionType) {
        int lifespan;
        int timestamp = this.commonLoginSession.getTimestamp();
        switch (actionType) {
            case CLIENT: {
                lifespan = this.realm.getAccessCodeLifespan();
                break;
            }
            case LOGIN: {
                lifespan = this.realm.getAccessCodeLifespanLogin() > 0 ? this.realm.getAccessCodeLifespanLogin() : this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            case USER: {
                lifespan = this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return timestamp + lifespan > Time.currentTime();
    }

    public boolean isValidAction(String requestedAction) {
        String action = this.commonLoginSession.getAction();
        if (action == null) {
            return false;
        }
        return action.equals(requestedAction);
    }

    public void removeExpiredClientSession() {
        CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        parser.removeExpiredSession(this.session, this.commonLoginSession);
    }

    public Set<RoleModel> getRequestedRoles() {
        return ClientSessionCode.getRequestedRoles(this.commonLoginSession, this.realm);
    }

    public static Set<RoleModel> getRequestedRoles(CommonClientSessionModel clientSession, RealmModel realm) {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (String roleId : clientSession.getRoles()) {
            RoleModel role = realm.getRoleById(roleId);
            if (role == null) continue;
            requestedRoles.add(role);
        }
        return requestedRoles;
    }

    public Set<ProtocolMapperModel> getRequestedProtocolMappers() {
        return ClientSessionCode.getRequestedProtocolMappers(this.commonLoginSession.getProtocolMappers(), this.commonLoginSession.getClient());
    }

    public static Set<ProtocolMapperModel> getRequestedProtocolMappers(Set<String> protocolMappers, ClientModel client) {
        HashSet<ProtocolMapperModel> requestedProtocolMappers = new HashSet<ProtocolMapperModel>();
        ClientTemplateModel template = client.getClientTemplate();
        if (protocolMappers != null) {
            for (String protocolMapperId : protocolMappers) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protocolMapperId);
                if (protocolMapper == null && template != null) {
                    protocolMapper = template.getProtocolMapperById(protocolMapperId);
                }
                if (protocolMapper == null) continue;
                requestedProtocolMappers.add(protocolMapper);
            }
        }
        return requestedProtocolMappers;
    }

    public void setAction(String action) {
        this.commonLoginSession.setAction(action);
        this.commonLoginSession.setTimestamp(Time.currentTime());
    }

    public String getCode() {
        CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        String nextCode = parser.getNote(this.commonLoginSession, ACTIVE_CODE);
        if (nextCode == null) {
            nextCode = ClientSessionCode.generateCode(this.commonLoginSession);
        } else {
            logger.debug((Object)"Code already generated for session, using same code");
        }
        return nextCode;
    }

    private static String generateCode(CommonClientSessionModel authSession) {
        try {
            String actionId = Base64Url.encode((byte[])KeycloakModelUtils.generateSecret());
            StringBuilder sb = new StringBuilder();
            sb.append(actionId);
            sb.append('.');
            sb.append(authSession.getId());
            CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(authSession.getClass());
            String code = parser.generateCode(authSession, actionId);
            parser.setNote(authSession, ACTIVE_CODE, code);
            return code;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifyCode(String code, CommonClientSessionModel authSession) {
        try {
            CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(authSession.getClass());
            String activeCode = parser.getNote(authSession, ACTIVE_CODE);
            if (activeCode == null) {
                logger.debug((Object)"Active code not found in client session");
                return false;
            }
            parser.removeNote(authSession, ACTIVE_CODE);
            return MessageDigest.isEqual(code.getBytes(), activeCode.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParseResult<CLIENT_SESSION extends CommonClientSessionModel> {
        ClientSessionCode<CLIENT_SESSION> code;
        boolean authSessionNotFound;
        boolean illegalHash;
        CLIENT_SESSION clientSession;

        public ClientSessionCode<CLIENT_SESSION> getCode() {
            return this.code;
        }

        public boolean isAuthSessionNotFound() {
            return this.authSessionNotFound;
        }

        public boolean isIllegalHash() {
            return this.illegalHash;
        }

        public CLIENT_SESSION getClientSession() {
            return this.clientSession;
        }
    }

    public static enum ActionType {
        CLIENT,
        LOGIN,
        USER;

    }
}

