/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.RealmModel;

public class DefaultKeyProviders {
    public static void createProviders(RealmModel realm) {
        ComponentModel generated = new ComponentModel();
        generated.setName("rsa-generated");
        generated.setParentId(realm.getId());
        generated.setProviderId("rsa-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        generated.setConfig(config);
        realm.addComponentModel(generated);
        DefaultKeyProviders.createSecretProvider(realm);
        DefaultKeyProviders.createAesProvider(realm);
    }

    public static void createSecretProvider(RealmModel realm) {
        ComponentModel generated = new ComponentModel();
        generated.setName("hmac-generated");
        generated.setParentId(realm.getId());
        generated.setProviderId("hmac-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        generated.setConfig(config);
        realm.addComponentModel(generated);
    }

    public static void createAesProvider(RealmModel realm) {
        ComponentModel generated = new ComponentModel();
        generated.setName("aes-generated");
        generated.setParentId(realm.getId());
        generated.setProviderId("aes-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        generated.setConfig(config);
        realm.addComponentModel(generated);
    }

    public static void createProviders(RealmModel realm, String privateKeyPem, String certificatePem) {
        ComponentModel rsa = new ComponentModel();
        rsa.setName("rsa");
        rsa.setParentId(realm.getId());
        rsa.setProviderId("rsa");
        rsa.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        config.putSingle((Object)"privateKey", (Object)privateKeyPem);
        if (certificatePem != null) {
            config.putSingle((Object)"certificate", (Object)certificatePem);
        }
        rsa.setConfig(config);
        realm.addComponentModel(rsa);
        DefaultKeyProviders.createSecretProvider(realm);
        DefaultKeyProviders.createAesProvider(realm);
    }
}

