/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.execactions;

import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHander;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.execactions.ExecuteActionsActionToken;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ExecuteActionsActionTokenHandler
extends AbstractActionTokenHander<ExecuteActionsActionToken> {
    public ExecuteActionsActionTokenHandler() {
        super("execute-actions", ExecuteActionsActionToken.class, "invalidCodeMessage", EventType.EXECUTE_ACTIONS, "not_allowed");
    }

    @Override
    public TokenVerifier.Predicate<? super ExecuteActionsActionToken>[] getVerifiers(ActionTokenContext<ExecuteActionsActionToken> tokenContext) {
        return TokenUtils.predicates(TokenUtils.checkThat(t -> t.getRedirectUri() == null || RedirectUtils.verifyRedirectUri(tokenContext.getUriInfo(), t.getRedirectUri(), tokenContext.getRealm(), tokenContext.getAuthenticationSession().getClient()) != null, "invalid_redirect_uri", "invalidRedirectUriMessage"));
    }

    @Override
    public Response handleToken(ExecuteActionsActionToken token, ActionTokenContext<ExecuteActionsActionToken> tokenContext) {
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        KeycloakSession session = tokenContext.getSession();
        if (tokenContext.isAuthenticationSessionFresh()) {
            token.setAuthenticationSessionId(authSession.getId());
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo));
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("confirmExecutionOfActions", new Object[0]).setAttribute("actionUri", (Object)confirmUri).setAttribute("requiredActions", token.getRequiredActions()).createInfoPage();
        }
        String redirectUri = RedirectUtils.verifyRedirectUri(tokenContext.getUriInfo(), token.getRedirectUri(), tokenContext.getRealm(), authSession.getClient());
        if (redirectUri != null) {
            authSession.setAuthNote("SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS", "true");
            authSession.setRedirectUri(redirectUri);
            authSession.setClientNote("redirect_uri", redirectUri);
        }
        token.getRequiredActions().stream().forEach(arg_0 -> ((AuthenticationSessionModel)authSession).addRequiredAction(arg_0));
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        user.setEmailVerified(true);
        String nextAction = AuthenticationManager.nextRequiredAction(tokenContext.getSession(), authSession, tokenContext.getClientConnection(), tokenContext.getRequest(), tokenContext.getUriInfo(), tokenContext.getEvent());
        return AuthenticationManager.redirectToRequiredActions(tokenContext.getSession(), tokenContext.getRealm(), authSession, tokenContext.getUriInfo(), nextAction);
    }

    @Override
    public boolean canUseTokenRepeatedly(ExecuteActionsActionToken token, ActionTokenContext<ExecuteActionsActionToken> tokenContext) {
        RealmModel realm = tokenContext.getRealm();
        KeycloakSessionFactory sessionFactory = tokenContext.getSession().getKeycloakSessionFactory();
        return token.getRequiredActions().stream().map(actionName -> realm.getRequiredActionProviderByAlias(actionName)).filter(Objects::nonNull).filter(RequiredActionProviderModel::isEnabled).map(RequiredActionProviderModel::getProviderId).map(providerId -> (RequiredActionFactory)sessionFactory.getProviderFactory(RequiredActionProvider.class, providerId)).filter(Objects::nonNull).noneMatch(RequiredActionFactory::isOneTimeAction);
    }
}

