/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationFlowURLHelper {
    protected static final Logger logger = Logger.getLogger(AuthenticationFlowURLHelper.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final UriInfo uriInfo;

    public AuthenticationFlowURLHelper(KeycloakSession session, RealmModel realm, UriInfo uriInfo) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
    }

    public Response showPageExpired(AuthenticationSessionModel authSession) {
        URI lastStepUrl = this.getLastExecutionUrl(authSession);
        logger.debugf("Redirecting to 'page expired' now. Will use last step URL: %s", (Object)lastStepUrl);
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setActionUri(lastStepUrl).setExecution(this.getExecutionId(authSession)).createLoginExpiredPage();
    }

    public URI getLastExecutionUrl(String flowPath, String executionId, String clientId) {
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(this.uriInfo).path(flowPath);
        if (executionId != null) {
            uriBuilder.queryParam("execution", new Object[]{executionId});
        }
        uriBuilder.queryParam("client_id", new Object[]{clientId});
        return uriBuilder.build(new Object[]{this.realm.getName()});
    }

    public URI getLastExecutionUrl(AuthenticationSessionModel authSession) {
        String executionId = this.getExecutionId(authSession);
        String latestFlowPath = authSession.getAuthNote("current.flow.path");
        if (latestFlowPath == null) {
            latestFlowPath = authSession.getClientNote("APP_INITIATED_FLOW");
        }
        if (latestFlowPath == null) {
            latestFlowPath = "authenticate";
        }
        return this.getLastExecutionUrl(latestFlowPath, executionId, authSession.getClient().getClientId());
    }

    private String getExecutionId(AuthenticationSessionModel authSession) {
        return authSession.getAuthNote("current.authentication.execution");
    }
}

