/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.common;

public class ParsingContext {
    private int offset;
    private int pos = -1;
    private String[] args;

    public ParsingContext(String[] args) {
        this(args, 0, -1);
    }

    public ParsingContext(String[] args, int offset) {
        this(args, offset, -1);
    }

    public ParsingContext(String[] args, int offset, int pos) {
        this.args = (String[])args.clone();
        this.offset = offset;
        this.pos = pos;
    }

    public boolean hasNext() {
        return this.pos < this.args.length - 1;
    }

    public boolean hasNext(int count) {
        return this.pos < this.args.length - count;
    }

    public boolean hasPrevious() {
        return this.pos > 0;
    }

    public String next() {
        if (this.hasNext()) {
            return this.args[++this.pos];
        }
        this.pos = this.args.length;
        return null;
    }

    public String nextRequired() {
        if (!this.hasNext()) {
            throw new RuntimeException("Option " + this.current() + " requires a value");
        }
        return this.next();
    }

    public String next(int n) {
        if (this.hasNext(n)) {
            this.pos += n;
            return this.args[this.pos];
        }
        this.pos = this.args.length;
        return null;
    }

    public String previous() {
        if (this.hasPrevious()) {
            return this.args[--this.pos];
        }
        this.pos = -1;
        return null;
    }

    public String current() {
        if (this.pos < 0 || this.pos >= this.args.length) {
            return null;
        }
        return this.args[this.pos];
    }

    public String[] getArgs() {
        return this.args;
    }
}

