/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@SerializeWith(value=ExternalizerImpl.class)
public class InitializerState
extends SessionEntity {
    private static final Logger log = Logger.getLogger(InitializerState.class);
    private final int sessionsCount;
    private final int segmentsCount;
    private final BitSet segments;
    private int lowestUnfinishedSegment = 0;

    public InitializerState(int sessionsCount, int sessionsPerSegment) {
        this.sessionsCount = sessionsCount;
        int segmentsCountLocal = sessionsCount / sessionsPerSegment;
        if (sessionsPerSegment * segmentsCountLocal < sessionsCount) {
            ++segmentsCountLocal;
        }
        this.segmentsCount = segmentsCountLocal;
        this.segments = new BitSet(segmentsCountLocal);
        log.debugf("sessionsCount: %d, sessionsPerSegment: %d, segmentsCount: %d", sessionsCount, sessionsPerSegment, segmentsCountLocal);
        this.updateLowestUnfinishedSegment();
    }

    private InitializerState(String realmId, int sessionsCount, int segmentsCount, BitSet segments) {
        super(realmId);
        this.sessionsCount = sessionsCount;
        this.segmentsCount = segmentsCount;
        this.segments = segments;
        log.debugf("sessionsCount: %d, segmentsCount: %d", sessionsCount, segmentsCount);
        this.updateLowestUnfinishedSegment();
    }

    public boolean isFinished() {
        return this.segments.cardinality() == this.segmentsCount;
    }

    public List<Integer> getUnfinishedSegments(int maxSegmentCount) {
        boolean remaining;
        LinkedList<Integer> result = new LinkedList<Integer>();
        int next = this.lowestUnfinishedSegment;
        boolean bl = remaining = this.lowestUnfinishedSegment != -1;
        while (remaining && result.size() < maxSegmentCount) {
            if ((next = this.getNextUnfinishedSegmentFromIndex(next)) == -1) {
                remaining = false;
                continue;
            }
            result.add(next);
            ++next;
        }
        return result;
    }

    public void markSegmentFinished(int index) {
        this.segments.set(index);
        this.updateLowestUnfinishedSegment();
    }

    private void updateLowestUnfinishedSegment() {
        this.lowestUnfinishedSegment = this.getNextUnfinishedSegmentFromIndex(this.lowestUnfinishedSegment);
    }

    private int getNextUnfinishedSegmentFromIndex(int index) {
        int nextFreeSegment = this.segments.nextClearBit(index);
        return nextFreeSegment < this.segmentsCount ? nextFreeSegment : -1;
    }

    public String toString() {
        int finished = this.segments.cardinality();
        int nonFinished = this.segmentsCount;
        return "sessionsCount: " + this.sessionsCount + ", finished segments count: " + finished + ", non-finished segments count: " + nonFinished;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.sessionsCount;
        hash = 97 * hash + this.segmentsCount;
        hash = 97 * hash + Objects.hashCode(this.segments);
        hash = 97 * hash + this.lowestUnfinishedSegment;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializerState other = (InitializerState)obj;
        if (this.sessionsCount != other.sessionsCount) {
            return false;
        }
        if (this.segmentsCount != other.segmentsCount) {
            return false;
        }
        if (this.lowestUnfinishedSegment != other.lowestUnfinishedSegment) {
            return false;
        }
        return Objects.equals(this.segments, other.segments);
    }

    public static class ExternalizerImpl
    implements Externalizer<InitializerState> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InitializerState value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.getRealmId(), (ObjectOutput)output);
            output.writeInt(value.sessionsCount);
            output.writeInt(value.segmentsCount);
            MarshallUtil.marshallByteArray((byte[])value.segments.toByteArray(), (ObjectOutput)output);
        }

        public InitializerState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InitializerState readObjectVersion1(ObjectInput input) throws IOException {
            return new InitializerState(MarshallUtil.unmarshallString((ObjectInput)input), input.readInt(), input.readInt(), BitSet.valueOf(MarshallUtil.unmarshallByteArray((ObjectInput)input)));
        }
    }
}

