/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.group;

import java.util.function.Function;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;

public class GroupPolicyProvider
implements PolicyProvider {
    private final Function<Policy, GroupPolicyRepresentation> representationFunction;

    public GroupPolicyProvider(Function<Policy, GroupPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        GroupPolicyRepresentation policy = this.representationFunction.apply(evaluation.getPolicy());
        RealmModel realm = evaluation.getAuthorizationProvider().getRealm();
        Attributes.Entry groupsClaim = evaluation.getContext().getIdentity().getAttributes().getValue(policy.getGroupsClaim());
        if (groupsClaim == null || groupsClaim.isEmpty()) {
            return;
        }
        for (GroupPolicyRepresentation.GroupDefinition definition : policy.getGroups()) {
            GroupModel allowedGroup = realm.getGroupById(definition.getId());
            for (int i = 0; i < groupsClaim.size(); ++i) {
                String allowedGroupPath;
                String group = groupsClaim.asString(i);
                if (group.indexOf(47) != -1 && (group.equals(allowedGroupPath = ModelToRepresentation.buildGroupPath((GroupModel)allowedGroup)) || definition.isExtendChildren() && group.startsWith(allowedGroupPath))) {
                    evaluation.grant();
                    return;
                }
                if (!group.equals(allowedGroup.getName())) continue;
                evaluation.grant();
                return;
            }
        }
    }

    public void close() {
    }
}

