/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo2_3_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.3.0");

    @Override
    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            this.migrateRealm(realm);
        }
    }

    protected void migrateRealm(RealmModel realm) {
        for (ClientModel client : realm.getClients()) {
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)client);
        }
        for (ClientTemplateModel clientTemplate : realm.getClientTemplates()) {
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)clientTemplate);
        }
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }
}

