/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.EnumClassBuilder;
import org.drools.core.factmodel.EnumClassDefinition;
import org.drools.core.factmodel.EnumLiteralDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.rule.builder.dialect.asm.ClassGenerator;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;

public class DefaultEnumClassBuilder
implements Opcodes,
EnumClassBuilder,
Serializable {
    @Override
    public byte[] buildClass(ClassDefinition classDef, ClassLoader classLoader) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        if (!(classDef instanceof EnumClassDefinition)) {
            throw new RuntimeException("FATAL : Trying to create an enum out of a bean class definition  " + classDef);
        }
        EnumClassDefinition edef = (EnumClassDefinition)classDef;
        ClassWriter cw = this.buildClassHeader(classLoader, edef);
        this.buildLiterals(cw, edef);
        this.buildFields(cw, edef);
        this.buildConstructors(cw, edef);
        this.buildGettersAndSetters(cw, edef);
        this.buildEqualityMethods(cw, edef);
        this.buildToString(cw, edef);
        cw.visitEnd();
        byte[] serializedClass = cw.toByteArray();
        return serializedClass;
    }

    protected ClassWriter buildClassHeader(ClassLoader classLoader, EnumClassDefinition classDef) {
        return ClassGenerator.createClassWriter(classLoader, 16433, BuildUtils.getInternalType(classDef.getClassName()), "Ljava/lang/Enum<" + BuildUtils.getTypeDescriptor(classDef.getClassName()) + ">;", BuildUtils.getInternalType(classDef.getSuperClass()), BuildUtils.getInternalTypes(classDef.getInterfaces()));
    }

    protected void buildLiterals(ClassWriter cw, EnumClassDefinition classDef) {
        FieldVisitor fv;
        for (EnumLiteralDefinition lit : classDef.getEnumLiterals()) {
            fv = cw.visitField(16409, lit.getName(), BuildUtils.getTypeDescriptor(classDef.getClassName()), null, null);
            fv.visitEnd();
        }
        fv = cw.visitField(4122, "$VALUES", "[" + BuildUtils.getTypeDescriptor(classDef.getClassName()), null, null);
        fv.visitEnd();
    }

    protected void buildFields(ClassWriter cw, EnumClassDefinition classDef) {
        FieldVisitor fv;
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            fv = cw.visitField(18, fld.getName(), BuildUtils.getTypeDescriptor(fld.getTypeName()), null, null);
            fv.visitEnd();
        }
        fv = cw.visitField(10, "$context", "Lorg/mvel2/ParserContext;", null, null);
        fv.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    protected void buildConstructors(ClassWriter cw, EnumClassDefinition classDef) throws IOException, ClassNotFoundException {
        void var7_12;
        EnumLiteralDefinition lit;
        void var7_10;
        String argTypes = "";
        int size = 0;
        for (FieldDefinition fieldDefinition : classDef.getFieldsDefinitions()) {
            argTypes = argTypes + BuildUtils.getTypeDescriptor(fieldDefinition.getTypeName());
            size += BuildUtils.sizeOf(fieldDefinition.getTypeName());
        }
        int ofs = 3;
        MethodVisitor mv = cw.visitMethod(2, "<init>", "(Ljava/lang/String;I" + argTypes + ")V", "(" + argTypes + ")V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V");
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(BuildUtils.varType(fld.getTypeName()), ofs);
            mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getName()), fld.getName(), BuildUtils.getTypeDescriptor(fld.getTypeName()));
            ofs += BuildUtils.sizeOf(fld.getTypeName());
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, ofs);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        int N = classDef.getEnumLiterals().size();
        mv.visitTypeInsn(187, BuildUtils.getInternalType(classDef.getClassName()));
        boolean bl = false;
        while (var7_10 < N) {
            lit = classDef.getEnumLiterals().get((int)var7_10);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)lit.getName());
            BuildUtils.pushInt(mv, (int)var7_10);
            List<String> args = lit.getConstructorArgs();
            for (int k = 0; k < args.size(); ++k) {
                String argType = classDef.getField(k).getTypeName();
                mv.visitLdcInsn((Object)args.get(k));
                mv.visitMethodInsn(184, "org/mvel2/MVEL", "eval", "(Ljava/lang/String;)Ljava/lang/Object;");
                if (BuildUtils.isPrimitive(argType)) {
                    mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(argType)));
                    mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(argType)), BuildUtils.numericMorph(BuildUtils.box(argType)), "()" + BuildUtils.getTypeDescriptor(argType));
                    continue;
                }
                mv.visitTypeInsn(192, BuildUtils.getInternalType(argType));
            }
            mv.visitMethodInsn(183, BuildUtils.getInternalType(classDef.getClassName()), "<init>", "(Ljava/lang/String;I" + argTypes + ")V");
            mv.visitFieldInsn(179, BuildUtils.getInternalType(classDef.getClassName()), lit.getName(), BuildUtils.getTypeDescriptor(classDef.getClassName()));
            mv.visitTypeInsn(187, BuildUtils.getInternalType(classDef.getClassName()));
            ++var7_10;
        }
        BuildUtils.pushInt(mv, N);
        mv.visitTypeInsn(189, BuildUtils.getInternalType(classDef.getClassName()));
        boolean bl2 = false;
        while (var7_12 < N) {
            lit = classDef.getEnumLiterals().get((int)var7_12);
            mv.visitInsn(89);
            BuildUtils.pushInt(mv, (int)var7_12);
            mv.visitFieldInsn(178, BuildUtils.getInternalType(classDef.getClassName()), lit.getName(), BuildUtils.getTypeDescriptor(classDef.getClassName()));
            mv.visitInsn(83);
            ++var7_12;
        }
        mv.visitFieldInsn(179, BuildUtils.getInternalType(classDef.getClassName()), "$VALUES", "[" + BuildUtils.getTypeDescriptor(classDef.getClassName()));
        mv.visitInsn(177);
        mv.visitMaxs(4 + size, 0);
        mv.visitEnd();
        mv = cw.visitMethod(9, "valueOf", "(Ljava/lang/String;)" + BuildUtils.getTypeDescriptor(classDef.getClassName()), null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(classDef.getClassName())));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
        mv.visitTypeInsn(192, BuildUtils.getInternalType(classDef.getClassName()));
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    protected void buildGettersAndSetters(ClassWriter cw, EnumClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(9, "values", "()[" + BuildUtils.getTypeDescriptor(classDef.getClassName()), null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, BuildUtils.getInternalType(classDef.getClassName()), "$VALUES", "[" + BuildUtils.getTypeDescriptor(classDef.getClassName()));
        mv.visitMethodInsn(182, "[" + BuildUtils.getTypeDescriptor(classDef.getClassName()), "clone", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "[" + BuildUtils.getTypeDescriptor(classDef.getClassName()));
        mv.visitInsn(176);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            mv = cw.visitMethod(1, BuildUtils.getterName(fld.getName(), fld.getTypeName()), "()" + BuildUtils.getTypeDescriptor(fld.getTypeName()), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getName()), fld.getName(), BuildUtils.getTypeDescriptor(fld.getTypeName()));
            mv.visitInsn(BuildUtils.returnType(fld.getTypeName()));
            mv.visitMaxs(BuildUtils.sizeOf(fld.getTypeName()), 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, BuildUtils.setterName(fld.getName(), fld.getTypeName()), "(" + BuildUtils.getTypeDescriptor(fld.getTypeName()) + ")V", null, null);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(0, 1 + BuildUtils.sizeOf(fld.getTypeName()));
            mv.visitEnd();
        }
        mv = cw.visitMethod(9, "get$context", "()Lorg/mvel2/ParserContext;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, BuildUtils.getInternalType(classDef.getName()), "$context", "Lorg/mvel2/ParserContext;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
        mv = cw.visitMethod(9, "set$context", "(Lorg/mvel2/ParserContext;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(179, BuildUtils.getInternalType(classDef.getName()), "$context", "Lorg/mvel2/ParserContext;");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    protected void buildToString(ClassWriter cw, EnumClassDefinition classDef) {
    }

    protected void buildEqualityMethods(ClassWriter cw, ClassDefinition classDef) {
    }
}

