/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import org.keycloak.component.ComponentModel;
import org.keycloak.component.PrioritizedComponentModel;
import org.keycloak.storage.UserStorageProvider;

public class UserStorageProviderModel
extends PrioritizedComponentModel {
    public static final String CACHE_POLICY = "cachePolicy";
    public static final String MAX_LIFESPAN = "maxLifespan";
    public static final String EVICTION_HOUR = "evictionHour";
    public static final String EVICTION_MINUTE = "evictionMinute";
    public static final String EVICTION_DAY = "evictionDay";
    public static final String CACHE_INVALID_BEFORE = "cacheInvalidBefore";
    public static final String IMPORT_ENABLED = "importEnabled";
    public static final String FULL_SYNC_PERIOD = "fullSyncPeriod";
    public static final String CHANGED_SYNC_PERIOD = "changedSyncPeriod";
    public static final String LAST_SYNC = "lastSync";
    public static final String ENABLED = "enabled";
    private transient Integer fullSyncPeriod;
    private transient Integer changedSyncPeriod;
    private transient Integer lastSync;
    private transient Boolean importEnabled;
    private transient Boolean enabled;
    private transient CachePolicy cachePolicy;
    private transient long maxLifespan = -1L;
    private transient int evictionHour = -1;
    private transient int evictionMinute = -1;
    private transient int evictionDay = -1;
    private transient long cacheInvalidBefore = -1L;

    public UserStorageProviderModel() {
        this.setProviderType(UserStorageProvider.class.getName());
    }

    public UserStorageProviderModel(ComponentModel copy) {
        super(copy);
    }

    public CachePolicy getCachePolicy() {
        if (this.cachePolicy == null) {
            String str = (String)this.getConfig().getFirst((Object)CACHE_POLICY);
            if (str == null) {
                return null;
            }
            this.cachePolicy = CachePolicy.valueOf(str);
        }
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
        if (cachePolicy == null) {
            this.getConfig().remove((Object)CACHE_POLICY);
        } else {
            this.getConfig().putSingle((Object)CACHE_POLICY, (Object)cachePolicy.name());
        }
    }

    public long getMaxLifespan() {
        if (this.maxLifespan < 0L) {
            String str = (String)this.getConfig().getFirst((Object)MAX_LIFESPAN);
            if (str == null) {
                return -1L;
            }
            this.maxLifespan = Long.valueOf(str);
        }
        return this.maxLifespan;
    }

    public void setMaxLifespan(long maxLifespan) {
        this.maxLifespan = maxLifespan;
        this.getConfig().putSingle((Object)MAX_LIFESPAN, (Object)Long.toString(maxLifespan));
    }

    public int getEvictionHour() {
        if (this.evictionHour < 0) {
            String str = (String)this.getConfig().getFirst((Object)EVICTION_HOUR);
            if (str == null) {
                return -1;
            }
            this.evictionHour = Integer.valueOf(str);
        }
        return this.evictionHour;
    }

    public void setEvictionHour(int evictionHour) {
        if (evictionHour > 23 || evictionHour < 0) {
            throw new IllegalArgumentException("Must be between 0 and 23");
        }
        this.evictionHour = evictionHour;
        this.getConfig().putSingle((Object)EVICTION_HOUR, (Object)Integer.toString(evictionHour));
    }

    public int getEvictionMinute() {
        if (this.evictionMinute < 0) {
            String str = (String)this.getConfig().getFirst((Object)EVICTION_MINUTE);
            if (str == null) {
                return -1;
            }
            this.evictionMinute = Integer.valueOf(str);
        }
        return this.evictionMinute;
    }

    public void setEvictionMinute(int evictionMinute) {
        if (evictionMinute > 59 || evictionMinute < 0) {
            throw new IllegalArgumentException("Must be between 0 and 59");
        }
        this.evictionMinute = evictionMinute;
        this.getConfig().putSingle((Object)EVICTION_MINUTE, (Object)Integer.toString(evictionMinute));
    }

    public int getEvictionDay() {
        if (this.evictionDay < 0) {
            String str = (String)this.getConfig().getFirst((Object)EVICTION_DAY);
            if (str == null) {
                return -1;
            }
            this.evictionDay = Integer.valueOf(str);
        }
        return this.evictionDay;
    }

    public void setEvictionDay(int evictionDay) {
        if (evictionDay > 7 || evictionDay < 1) {
            throw new IllegalArgumentException("Must be between 1 and 7");
        }
        this.evictionDay = evictionDay;
        this.getConfig().putSingle((Object)EVICTION_DAY, (Object)Integer.toString(evictionDay));
    }

    public long getCacheInvalidBefore() {
        if (this.cacheInvalidBefore < 0L) {
            String str = (String)this.getConfig().getFirst((Object)CACHE_INVALID_BEFORE);
            if (str == null) {
                return -1L;
            }
            this.cacheInvalidBefore = Long.valueOf(str);
        }
        return this.cacheInvalidBefore;
    }

    public void setCacheInvalidBefore(long cacheInvalidBefore) {
        this.cacheInvalidBefore = cacheInvalidBefore;
        this.getConfig().putSingle((Object)CACHE_INVALID_BEFORE, (Object)Long.toString(cacheInvalidBefore));
    }

    public boolean isImportEnabled() {
        if (this.importEnabled == null) {
            String val = (String)this.getConfig().getFirst((Object)IMPORT_ENABLED);
            this.importEnabled = val == null ? Boolean.valueOf(true) : Boolean.valueOf(val);
        }
        return this.importEnabled;
    }

    public void setImportEnabled(boolean flag) {
        this.importEnabled = flag;
        this.getConfig().putSingle((Object)IMPORT_ENABLED, (Object)Boolean.toString(flag));
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        this.getConfig().putSingle((Object)ENABLED, (Object)Boolean.toString(flag));
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            String val = (String)this.getConfig().getFirst((Object)ENABLED);
            this.enabled = val == null ? Boolean.valueOf(true) : Boolean.valueOf(val);
        }
        return this.enabled;
    }

    public int getFullSyncPeriod() {
        if (this.fullSyncPeriod == null) {
            String val = (String)this.getConfig().getFirst((Object)FULL_SYNC_PERIOD);
            this.fullSyncPeriod = val == null ? Integer.valueOf(-1) : Integer.valueOf(val);
        }
        return this.fullSyncPeriod;
    }

    public void setFullSyncPeriod(int fullSyncPeriod) {
        this.fullSyncPeriod = fullSyncPeriod;
        this.getConfig().putSingle((Object)FULL_SYNC_PERIOD, (Object)Integer.toString(fullSyncPeriod));
    }

    public int getChangedSyncPeriod() {
        if (this.changedSyncPeriod == null) {
            String val = (String)this.getConfig().getFirst((Object)CHANGED_SYNC_PERIOD);
            this.changedSyncPeriod = val == null ? Integer.valueOf(-1) : Integer.valueOf(val);
        }
        return this.changedSyncPeriod;
    }

    public void setChangedSyncPeriod(int changedSyncPeriod) {
        this.changedSyncPeriod = changedSyncPeriod;
        this.getConfig().putSingle((Object)CHANGED_SYNC_PERIOD, (Object)Integer.toString(changedSyncPeriod));
    }

    public int getLastSync() {
        if (this.lastSync == null) {
            String val = (String)this.getConfig().getFirst((Object)LAST_SYNC);
            this.lastSync = val == null ? Integer.valueOf(0) : Integer.valueOf(val);
        }
        return this.lastSync;
    }

    public void setLastSync(int lastSync) {
        this.lastSync = lastSync;
        this.getConfig().putSingle((Object)LAST_SYNC, (Object)Integer.toString(lastSync));
    }

    public static enum CachePolicy {
        NO_CACHE,
        DEFAULT,
        EVICT_DAILY,
        EVICT_WEEKLY,
        MAX_LIFESPAN;

    }
}

