/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.CachedClient;
import org.keycloak.models.cache.infinispan.entities.CachedClientTemplate;
import org.keycloak.models.cache.infinispan.entities.CachedGroup;
import org.keycloak.models.cache.infinispan.entities.CachedRole;
import org.keycloak.models.cache.infinispan.entities.Revisioned;
import org.keycloak.models.cache.infinispan.entities.RoleQuery;

@SerializeWith(value=ExternalizerImpl.class)
public class HasRolePredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String role;

    public static HasRolePredicate create() {
        return new HasRolePredicate();
    }

    public HasRolePredicate role(String role) {
        this.role = role;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        CachedClientTemplate cachedClientTemplate;
        CachedClient cachedClient;
        RoleQuery roleQuery;
        AbstractRevisioned cachedRole;
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (value instanceof CachedRole && ((CachedRole)(cachedRole = (CachedRole)value)).getComposites().contains(this.role)) {
            return true;
        }
        if (value instanceof CachedGroup && ((CachedGroup)(cachedRole = (CachedGroup)value)).getRoleMappings().contains(this.role)) {
            return true;
        }
        if (value instanceof RoleQuery && (roleQuery = (RoleQuery)value).getRoles().contains(this.role)) {
            return true;
        }
        if (value instanceof CachedClient && (cachedClient = (CachedClient)value).getScope().contains(this.role)) {
            return true;
        }
        return value instanceof CachedClientTemplate && (cachedClientTemplate = (CachedClientTemplate)value).getScope().contains(this.role);
    }

    public static class ExternalizerImpl
    implements Externalizer<HasRolePredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, HasRolePredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.role, (ObjectOutput)output);
        }

        public HasRolePredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public HasRolePredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            HasRolePredicate res = new HasRolePredicate();
            res.role = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

