/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.io.IOException;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.AbstractVirtualFileFilterWithAttributes;
import org.keycloak.subsystem.server.extension.KeycloakAdapterConfigService;

public class KeycloakProviderDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier KEYCLOAK_COMMON = ModuleIdentifier.create((String)"org.keycloak.keycloak-common");
    private static final ModuleIdentifier KEYCLOAK_CORE = ModuleIdentifier.create((String)"org.keycloak.keycloak-core");
    private static final ModuleIdentifier KEYCLOAK_SERVER_SPI = ModuleIdentifier.create((String)"org.keycloak.keycloak-server-spi");
    private static final ModuleIdentifier KEYCLOAK_SERVER_SPI_PRIVATE = ModuleIdentifier.create((String)"org.keycloak.keycloak-server-spi-private");
    private static final ModuleIdentifier KEYCLOAK_JPA = ModuleIdentifier.create((String)"org.keycloak.keycloak-model-jpa");
    private static final ModuleIdentifier JAXRS = ModuleIdentifier.create((String)"javax.ws.rs.api");
    private static final ModuleIdentifier RESTEASY = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxrs");
    private static final ModuleIdentifier APACHE = ModuleIdentifier.create((String)"org.apache.httpcomponents");
    private static final Logger logger = Logger.getLogger(KeycloakProviderDependencyProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        KeycloakAdapterConfigService config = KeycloakAdapterConfigService.INSTANCE;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        if (config.isKeycloakServerDeployment(deploymentName)) {
            return;
        }
        if (!KeycloakProviderDependencyProcessor.isKeycloakProviderDeployment(deploymentUnit)) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_COMMON, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_CORE, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_SERVER_SPI, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_SERVER_SPI_PRIVATE, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JAXRS, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, RESTEASY, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, APACHE, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_JPA, false, false, false, false));
    }

    public static boolean isKeycloakProviderDeployment(DeploymentUnit du) {
        ResourceRoot resourceRoot = (ResourceRoot)du.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot == null) {
            return false;
        }
        VirtualFile deploymentRoot = resourceRoot.getRoot();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return false;
        }
        VirtualFile services = deploymentRoot.getChild("META-INF/services");
        if (!services.exists()) {
            return false;
        }
        try {
            List archives = services.getChildren((VirtualFileFilter)new AbstractVirtualFileFilterWithAttributes(){

                public boolean accepts(VirtualFile file) {
                    return file.getName().startsWith("org.keycloak");
                }
            });
            return !archives.isEmpty();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

