/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Permission {
    @JsonProperty(value="rsid")
    private String resourceId;
    @JsonProperty(value="rsname")
    private final String resourceName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> scopes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Set<String>> claims;

    public Permission() {
        this(null, null, null, null);
    }

    public Permission(String resourceId, String resourceName, Set<String> scopes, Map<String, Set<String>> claims) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.scopes = scopes;
        this.claims = claims;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Set<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        return this.scopes;
    }

    public Map<String, Set<String>> getClaims() {
        return this.claims;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Permission {").append("id=").append(this.resourceId).append(", name=").append(this.resourceName).append(", scopes=").append(this.scopes).append("}");
        return builder.toString();
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }
}

