/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.cli;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class CliUsernamePasswordAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator {
    public boolean requiresUser() {
        return false;
    }

    public void authenticate(AuthenticationFlowContext context) {
        String header = this.getHeader(context);
        Response response = context.form().setStatus(Response.Status.UNAUTHORIZED).setMediaType(MediaType.TEXT_PLAIN_TYPE).setResponseHeader("WWW-Authenticate", header).createForm("cli_splash.ftl");
        context.challenge(response);
    }

    private String getHeader(AuthenticationFlowContext context) {
        URI callback = this.getCallbackUrl(context);
        return "X-Text-Form-Challenge callback=\"" + callback + "\" param=\"username\" label=\"Username: \" mask=false param=\"password\" label=\"Password: \" mask=true";
    }

    private URI getCallbackUrl(AuthenticationFlowContext context) {
        return context.getActionUrl(context.generateAccessCode(), true);
    }

    @Override
    protected Response invalidUser(AuthenticationFlowContext context) {
        String header = this.getHeader(context);
        Response response = Response.status((int)401).type(MediaType.TEXT_PLAIN_TYPE).header("WWW-Authenticate", (Object)header).entity((Object)("\n" + context.form().getMessage("invalidUserMessage") + "\n")).build();
        return response;
    }

    @Override
    protected Response disabledUser(AuthenticationFlowContext context) {
        String header = this.getHeader(context);
        Response response = Response.status((int)401).type(MediaType.TEXT_PLAIN_TYPE).header("WWW-Authenticate", (Object)header).entity((Object)("\n" + context.form().getMessage("accountDisabledMessage") + "\n")).build();
        return response;
    }

    @Override
    protected Response temporarilyDisabledUser(AuthenticationFlowContext context) {
        String header = this.getHeader(context);
        Response response = Response.status((int)401).type(MediaType.TEXT_PLAIN_TYPE).header("WWW-Authenticate", (Object)header).entity((Object)("\n" + context.form().getMessage("invalidUserMessage") + "\n")).build();
        return response;
    }

    @Override
    protected Response invalidCredentials(AuthenticationFlowContext context) {
        String header = this.getHeader(context);
        Response response = Response.status((int)401).type(MediaType.TEXT_PLAIN_TYPE).header("WWW-Authenticate", (Object)header).entity((Object)("\n" + context.form().getMessage("invalidUserMessage") + "\n")).build();
        return response;
    }

    @Override
    protected Response setDuplicateUserChallenge(AuthenticationFlowContext context, String eventError, String loginFormError, AuthenticationFlowError authenticatorError) {
        context.getEvent().error(eventError);
        String header = this.getHeader(context);
        Response challengeResponse = Response.status((int)401).type(MediaType.TEXT_PLAIN_TYPE).header("WWW-Authenticate", (Object)header).entity((Object)("\n" + context.form().getMessage(loginFormError) + "\n")).build();
        context.failureChallenge(authenticatorError, challengeResponse);
        return challengeResponse;
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (!this.validateUserAndPassword(context, (MultivaluedMap<String, String>)formData)) {
            return;
        }
        context.success();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }
}

