/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.validation.Validation;

public class UpdateProfile
implements RequiredActionProvider,
RequiredActionFactory {
    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        boolean emailChanged;
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_PROFILE);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        UserModel user = context.getUser();
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        List<FormMessage> errors = Validation.validateUpdateProfileForm(realm, (MultivaluedMap<String, String>)formData);
        if (errors != null && !errors.isEmpty()) {
            Response challenge = context.form().setErrors(errors).setFormData(formData).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
            context.challenge(challenge);
            return;
        }
        if (realm.isEditUsernameAllowed()) {
            boolean usernameChanged;
            String username = (String)formData.getFirst((Object)"username");
            String oldUsername = user.getUsername();
            boolean bl = oldUsername != null ? !oldUsername.equals(username) : (usernameChanged = username != null);
            if (usernameChanged) {
                if (session.users().getUserByUsername(username, realm) != null) {
                    Response challenge = context.form().setError("usernameExistsMessage", new Object[0]).setFormData(formData).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
                    context.challenge(challenge);
                    return;
                }
                user.setUsername(username);
            }
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        String email = (String)formData.getFirst((Object)"email");
        String oldEmail = user.getEmail();
        boolean bl = oldEmail != null ? !oldEmail.equals(email) : (emailChanged = email != null);
        if (emailChanged) {
            UserModel userByEmail;
            if (!realm.isDuplicateEmailsAllowed() && (userByEmail = session.users().getUserByEmail(email, realm)) != null && !userByEmail.getId().equals(user.getId())) {
                Response challenge = context.form().setError("emailExistsMessage", new Object[0]).setFormData(formData).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
                context.challenge(challenge);
                return;
            }
            user.setEmail(email);
            user.setEmailVerified(false);
        }
        AttributeFormDataProcessor.process((MultivaluedMap<String, String>)formData, realm, user);
        if (emailChanged) {
            event.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", email).success();
        }
        context.success();
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Profile";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PROFILE.name();
    }
}

