/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.permission;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.permission.AbstractPermissionService;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.services.ErrorResponseException;

public class PermissionService
extends AbstractPermissionService {
    private final AuthorizationProvider authorization;
    private final ResourceServer resourceServer;

    public PermissionService(KeycloakIdentity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        super(identity, resourceServer, authorization);
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @Override
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(List<PermissionRequest> request) {
        return super.create(request);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(PermissionTicketRepresentation representation) {
        if (representation == null || representation.getId() == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        PermissionTicketStore ticketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
        PermissionTicket ticket = ticketStore.findById(representation.getId(), this.resourceServer.getId());
        if (ticket == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        RepresentationToModel.toModel((PermissionTicketRepresentation)representation, (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization);
        return Response.noContent().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response delete(String id) {
        if (id == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        PermissionTicketStore ticketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
        PermissionTicket ticket = ticketStore.findById(id, this.resourceServer.getId());
        if (ticket == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        ticketStore.delete(id);
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="scopeId") String scopeId, @QueryParam(value="resourceId") String resourceId, @QueryParam(value="owner") String owner, @QueryParam(value="requester") String requester, @QueryParam(value="granted") Boolean granted, @QueryParam(value="returnNames") Boolean returnNames, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        PermissionTicketStore permissionTicketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
        HashMap<String, String> filters = new HashMap<String, String>();
        if (resourceId != null) {
            filters.put("resource.id", resourceId);
        }
        if (scopeId != null) {
            filters.put("scope.id", scopeId);
        }
        if (owner != null) {
            filters.put("owner", owner);
        }
        if (requester != null) {
            filters.put("requester", requester);
        }
        if (granted != null) {
            filters.put("granted", granted.toString());
        }
        return Response.ok().entity(permissionTicketStore.find(filters, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100).stream().map(permissionTicket -> ModelToRepresentation.toRepresentation((PermissionTicket)permissionTicket, (boolean)(returnNames == null ? false : returnNames))).collect(Collectors.toList())).build();
    }
}

