/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email.freemarker;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.email.freemarker.beans.EventBean;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.LinkExpirationFormatterMethod;
import org.keycloak.theme.beans.MessageFormatterMethod;

public class FreeMarkerEmailTemplateProvider
implements EmailTemplateProvider {
    protected KeycloakSession session;
    protected AuthenticationSessionModel authenticationSession;
    protected FreeMarkerUtil freeMarker;
    protected RealmModel realm;
    protected UserModel user;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    public FreeMarkerEmailTemplateProvider(KeycloakSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
    }

    public EmailTemplateProvider setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public EmailTemplateProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public EmailTemplateProvider setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public EmailTemplateProvider setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        return this;
    }

    protected String getRealmName() {
        if (this.realm.getDisplayName() != null) {
            return this.realm.getDisplayName();
        }
        return ObjectUtil.capitalize((String)this.realm.getName());
    }

    public void sendEvent(Event event) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("user", new ProfileBean(this.user));
        attributes.put("event", new EventBean(event));
        this.send(this.toCamelCase(event.getType()) + "Subject", "event-" + event.getType().toString().toLowerCase() + ".ftl", attributes);
    }

    public void sendPasswordReset(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        attributes.put("user", new ProfileBean(this.user));
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        attributes.put("realmName", this.getRealmName());
        this.send("passwordResetSubject", "password-reset.ftl", attributes);
    }

    public void sendSmtpTestEmail(Map<String, String> config, UserModel user) throws EmailException {
        this.setRealm(this.session.getContext().getRealm());
        this.setUser(user);
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        attributes.put("user", new ProfileBean(user));
        attributes.put("realmName", this.realm.getName());
        EmailTemplate email = this.processTemplate("emailTestSubject", Collections.emptyList(), "email-test.ftl", attributes);
        this.send(config, email.getSubject(), email.getTextBody(), email.getHtmlBody());
    }

    public void sendConfirmIdentityBrokerLink(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        attributes.put("user", new ProfileBean(this.user));
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        attributes.put("realmName", this.getRealmName());
        BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
        String idpAlias = brokerContext.getIdpConfig().getAlias();
        idpAlias = ObjectUtil.capitalize((String)idpAlias);
        attributes.put("identityProviderContext", brokerContext);
        attributes.put("identityProviderAlias", idpAlias);
        List<Object> subjectAttrs = Arrays.asList(idpAlias);
        this.send("identityProviderLinkSubject", subjectAttrs, "identity-provider-link.ftl", attributes);
    }

    public void sendExecuteActions(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        attributes.put("user", new ProfileBean(this.user));
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        attributes.put("realmName", this.getRealmName());
        this.send("executeActionsSubject", "executeActions.ftl", attributes);
    }

    public void sendVerifyEmail(String link, long expirationInMinutes) throws EmailException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        attributes.put("user", new ProfileBean(this.user));
        this.addLinkInfoIntoAttributes(link, expirationInMinutes, attributes);
        attributes.put("realmName", this.getRealmName());
        this.send("emailVerificationSubject", "email-verification.ftl", attributes);
    }

    protected void addLinkInfoIntoAttributes(String link, long expirationInMinutes, Map<String, Object> attributes) throws EmailException {
        attributes.put("link", link);
        attributes.put("linkExpiration", expirationInMinutes);
        try {
            Locale locale = this.session.getContext().resolveLocale(this.user);
            attributes.put("linkExpirationFormatter", new LinkExpirationFormatterMethod(this.getTheme().getMessages(locale), locale));
        }
        catch (IOException e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    protected void send(String subjectKey, String template, Map<String, Object> attributes) throws EmailException {
        this.send(subjectKey, Collections.emptyList(), template, attributes);
    }

    protected EmailTemplate processTemplate(String subjectKey, List<Object> subjectAttributes, String template, Map<String, Object> attributes) throws EmailException {
        try {
            String htmlBody;
            String textBody;
            Theme theme = this.getTheme();
            Locale locale = this.session.getContext().resolveLocale(this.user);
            attributes.put("locale", locale);
            Properties rb = theme.getMessages(locale);
            attributes.put("msg", new MessageFormatterMethod(locale, rb));
            String subject = new MessageFormat(rb.getProperty(subjectKey, subjectKey), locale).format(subjectAttributes.toArray());
            String textTemplate = String.format("text/%s", template);
            try {
                textBody = this.freeMarker.processTemplate(attributes, textTemplate, theme);
            }
            catch (FreeMarkerException e) {
                textBody = null;
            }
            String htmlTemplate = String.format("html/%s", template);
            try {
                htmlBody = this.freeMarker.processTemplate(attributes, htmlTemplate, theme);
            }
            catch (FreeMarkerException e) {
                htmlBody = null;
            }
            return new EmailTemplate(subject, textBody, htmlBody);
        }
        catch (Exception e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    protected Theme getTheme() throws IOException {
        return this.session.theme().getTheme(Theme.Type.EMAIL);
    }

    protected void send(String subjectKey, List<Object> subjectAttributes, String template, Map<String, Object> attributes) throws EmailException {
        try {
            EmailTemplate email = this.processTemplate(subjectKey, subjectAttributes, template, attributes);
            this.send(email.getSubject(), email.getTextBody(), email.getHtmlBody());
        }
        catch (EmailException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    protected void send(String subject, String textBody, String htmlBody) throws EmailException {
        this.send(this.realm.getSmtpConfig(), subject, textBody, htmlBody);
    }

    protected void send(Map<String, String> config, String subject, String textBody, String htmlBody) throws EmailException {
        EmailSenderProvider emailSender = (EmailSenderProvider)this.session.getProvider(EmailSenderProvider.class);
        emailSender.send(config, this.user, subject, textBody, htmlBody);
    }

    public void close() {
    }

    protected String toCamelCase(EventType event) {
        StringBuilder sb = new StringBuilder("event");
        for (String s : event.name().toLowerCase().split("_")) {
            sb.append(ObjectUtil.capitalize((String)s));
        }
        return sb.toString();
    }

    protected class EmailTemplate {
        private String subject;
        private String textBody;
        private String htmlBody;

        public EmailTemplate(String subject, String textBody, String htmlBody) {
            this.subject = subject;
            this.textBody = textBody;
            this.htmlBody = htmlBody;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getTextBody() {
            return this.textBody;
        }

        public String getHtmlBody() {
            return this.htmlBody;
        }
    }
}

