/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class AuthorizationBean {
    private final UserModel user;
    private final AuthorizationProvider authorization;
    private final UriInfo uriInfo;
    private ResourceBean resource;
    private List<ResourceBean> resources;
    private Collection<ResourceBean> userSharedResources;
    private Collection<ResourceBean> requestsWaitingPermission;
    private Collection<ResourceBean> resourcesWaitingOthersApproval;

    public AuthorizationBean(KeycloakSession session, UserModel user, UriInfo uriInfo) {
        Resource resource;
        this.user = user;
        this.uriInfo = uriInfo;
        this.authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        List pathParameters = (List)uriInfo.getPathParameters().get((Object)"resource_id");
        if (pathParameters != null && !pathParameters.isEmpty() && (resource = this.authorization.getStoreFactory().getResourceStore().findById((String)pathParameters.get(0), null)) != null && !resource.getOwner().equals(user.getId())) {
            throw new RuntimeException("User [" + user.getUsername() + "] can not access resource [" + resource.getId() + "]");
        }
    }

    public Collection<ResourceBean> getResourcesWaitingOthersApproval() {
        if (this.resourcesWaitingOthersApproval == null) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("requester", this.user.getId());
            filters.put("granted", Boolean.FALSE.toString());
            this.resourcesWaitingOthersApproval = this.toResourceRepresentation(this.findPermissions(filters));
        }
        return this.resourcesWaitingOthersApproval;
    }

    public Collection<ResourceBean> getResourcesWaitingApproval() {
        if (this.requestsWaitingPermission == null) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("owner", this.user.getId());
            filters.put("granted", Boolean.FALSE.toString());
            this.requestsWaitingPermission = this.toResourceRepresentation(this.findPermissions(filters));
        }
        return this.requestsWaitingPermission;
    }

    public List<ResourceBean> getResources() {
        if (this.resources == null) {
            this.resources = this.authorization.getStoreFactory().getResourceStore().findByOwner(this.user.getId(), null).stream().filter(Resource::isOwnerManagedAccess).map(x$0 -> new ResourceBean((Resource)x$0)).collect(Collectors.toList());
        }
        return this.resources;
    }

    public Collection<ResourceBean> getSharedResources() {
        if (this.userSharedResources == null) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("requester", this.user.getId());
            filters.put("granted", Boolean.TRUE.toString());
            PermissionTicketStore ticketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
            this.userSharedResources = this.toResourceRepresentation(ticketStore.find(filters, null, -1, -1));
        }
        return this.userSharedResources;
    }

    public ResourceBean getResource() {
        String resourceId;
        if (this.resource == null && (resourceId = (String)this.uriInfo.getPathParameters().getFirst((Object)"resource_id")) != null) {
            this.resource = this.getResource(resourceId);
        }
        return this.resource;
    }

    private ResourceBean getResource(String id) {
        return new ResourceBean(this.authorization.getStoreFactory().getResourceStore().findById(id, null));
    }

    private Collection<RequesterBean> toPermissionRepresentation(List<PermissionTicket> permissionRequests) {
        HashMap<String, RequesterBean> requests = new HashMap<String, RequesterBean>();
        for (PermissionTicket ticket : permissionRequests) {
            Resource resource = ticket.getResource();
            if (!resource.isOwnerManagedAccess()) continue;
            requests.computeIfAbsent(ticket.getRequester(), resourceId -> new RequesterBean(ticket, this.authorization)).addScope(ticket);
        }
        return requests.values();
    }

    private Collection<ResourceBean> toResourceRepresentation(List<PermissionTicket> tickets) {
        HashMap<String, ResourceBean> requests = new HashMap<String, ResourceBean>();
        for (PermissionTicket ticket : tickets) {
            Resource resource = ticket.getResource();
            if (!resource.isOwnerManagedAccess()) continue;
            requests.computeIfAbsent(resource.getId(), resourceId -> this.getResource((String)resourceId)).addPermission(ticket, this.authorization);
        }
        return requests.values();
    }

    private List<PermissionTicket> findPermissions(Map<String, String> filters) {
        return this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, null, -1, -1);
    }

    public class ResourceServerBean {
        private ClientModel clientModel;

        public ResourceServerBean(ClientModel clientModel) {
            this.clientModel = clientModel;
        }

        public String getName() {
            String name = this.clientModel.getName();
            if (name != null) {
                return name;
            }
            return this.clientModel.getClientId();
        }

        public String getRedirectUri() {
            Set redirectUris = this.clientModel.getRedirectUris();
            if (redirectUris.isEmpty()) {
                return null;
            }
            return (String)redirectUris.iterator().next();
        }
    }

    public class ResourceBean {
        private final ResourceServerBean resourceServer;
        private final UserModel owner;
        private Resource resource;
        private Map<String, RequesterBean> permissions = new HashMap<String, RequesterBean>();
        private Collection<RequesterBean> shares;

        public ResourceBean(Resource resource) {
            RealmModel realm = AuthorizationBean.this.authorization.getRealm();
            this.resourceServer = new ResourceServerBean(realm.getClientById(resource.getResourceServer().getId()));
            this.resource = resource;
            this.owner = AuthorizationBean.this.authorization.getKeycloakSession().users().getUserById(resource.getOwner(), realm);
        }

        public String getId() {
            return this.resource.getId();
        }

        public String getName() {
            return this.resource.getName();
        }

        public String getDisplayName() {
            return this.resource.getDisplayName();
        }

        public String getIconUri() {
            return this.resource.getIconUri();
        }

        public UserModel getOwner() {
            return this.owner;
        }

        public List<ScopeRepresentation> getScopes() {
            return this.resource.getScopes().stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        }

        public Collection<RequesterBean> getShares() {
            if (this.shares == null) {
                HashMap<String, String> filters = new HashMap<String, String>();
                filters.put("resource.id", this.resource.getId());
                filters.put("granted", Boolean.TRUE.toString());
                this.shares = AuthorizationBean.this.toPermissionRepresentation(AuthorizationBean.this.findPermissions(filters));
            }
            return this.shares;
        }

        public ResourceServerBean getResourceServer() {
            return this.resourceServer;
        }

        public Collection<RequesterBean> getPermissions() {
            return this.permissions.values();
        }

        private void addPermission(PermissionTicket ticket, AuthorizationProvider authorization) {
            this.permissions.computeIfAbsent(ticket.getRequester(), key -> new RequesterBean(ticket, authorization)).addScope(ticket);
        }
    }

    public static class PermissionScopeBean {
        private final Scope scope;
        private final PermissionTicket ticket;

        public PermissionScopeBean(PermissionTicket ticket) {
            this.ticket = ticket;
            this.scope = ticket.getScope();
        }

        public String getId() {
            return this.ticket.getId();
        }

        public Scope getScope() {
            return this.scope;
        }

        public boolean isGranted() {
            return this.ticket.isGranted();
        }

        private Date getGrantedDate() {
            if (this.isGranted()) {
                return Time.toDate((long)this.ticket.getGrantedTimestamp());
            }
            return null;
        }
    }

    public static class RequesterBean {
        private final Long createdTimestamp;
        private final Long grantedTimestamp;
        private UserModel requester;
        private List<PermissionScopeBean> scopes = new ArrayList<PermissionScopeBean>();
        private boolean granted;

        public RequesterBean(PermissionTicket ticket, AuthorizationProvider authorization) {
            this.requester = authorization.getKeycloakSession().users().getUserById(ticket.getRequester(), authorization.getRealm());
            this.granted = ticket.isGranted();
            this.createdTimestamp = ticket.getCreatedTimestamp();
            this.grantedTimestamp = ticket.getGrantedTimestamp();
        }

        public UserModel getRequester() {
            return this.requester;
        }

        public List<PermissionScopeBean> getScopes() {
            return this.scopes;
        }

        private void addScope(PermissionTicket ticket) {
            if (ticket != null) {
                this.scopes.add(new PermissionScopeBean(ticket));
            }
        }

        public boolean isGranted() {
            return this.granted && this.scopes.isEmpty() || this.scopes.stream().filter(permissionScopeBean -> permissionScopeBean.isGranted()).count() > 0L;
        }

        public Date getCreatedDate() {
            return Time.toDate((long)this.createdTimestamp);
        }

        public Date getGrantedDate() {
            if (this.grantedTimestamp == null) {
                PermissionScopeBean permission = this.scopes.stream().filter(permissionScopeBean -> permissionScopeBean.isGranted()).findFirst().orElse(null);
                if (permission == null) {
                    return null;
                }
                return permission.getGrantedDate();
            }
            return Time.toDate((long)this.grantedTimestamp);
        }
    }
}

