/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.storage.jpa.entity.FederatedUserConsentEntity;

@NamedQueries(value={@NamedQuery(name="deleteFederatedUserConsentRolesByRealm", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.realmId = :realmId)"), @NamedQuery(name="deleteFederatedUserConsentRolesByUser", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.userId = :userId and consent.realmId = :realmId)"), @NamedQuery(name="deleteFederatedUserConsentRolesByStorageProvider", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.storageProviderId = :storageProviderId)"), @NamedQuery(name="deleteFederatedUserConsentRolesByRole", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.roleId = :roleId"), @NamedQuery(name="deleteFederatedUserConsentRolesByClient", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.clientId = :clientId)"), @NamedQuery(name="deleteFederatedUserConsentRolesByExternalClient", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.clientStorageProvider = :clientStorageProvider and consent.externalClientId = :externalClientId)"), @NamedQuery(name="deleteFederatedUserConsentRolesByClientStorageProvider", query="delete from FederatedUserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.clientStorageProvider = :clientStorageProvider)")})
@Entity
@Table(name="FED_USER_CONSENT_ROLE")
@IdClass(value=Key.class)
public class FederatedUserConsentRoleEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_CONSENT_ID")
    protected FederatedUserConsentEntity userConsent;
    @Id
    @Column(name="ROLE_ID")
    protected String roleId;

    public FederatedUserConsentEntity getUserConsent() {
        return this.userConsent;
    }

    public void setUserConsent(FederatedUserConsentEntity userConsent) {
        this.userConsent = userConsent;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FederatedUserConsentRoleEntity)) {
            return false;
        }
        FederatedUserConsentRoleEntity that = (FederatedUserConsentRoleEntity)o;
        Key myKey = new Key(this.userConsent, this.roleId);
        Key hisKey = new Key(that.userConsent, that.roleId);
        return myKey.equals(hisKey);
    }

    public int hashCode() {
        Key myKey = new Key(this.userConsent, this.roleId);
        return myKey.hashCode();
    }

    public static class Key
    implements Serializable {
        protected FederatedUserConsentEntity userConsent;
        protected String roleId;

        public Key() {
        }

        public Key(FederatedUserConsentEntity userConsent, String roleId) {
            this.userConsent = userConsent;
            this.roleId = roleId;
        }

        public FederatedUserConsentEntity getUserConsent() {
            return this.userConsent;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userConsent != null ? !this.userConsent.getId().equals(key.userConsent != null ? key.userConsent.getId() : null) : key.userConsent != null) {
                return false;
            }
            return !(this.roleId != null ? !this.roleId.equals(key.roleId) : key.roleId != null);
        }

        public int hashCode() {
            int result = this.userConsent != null ? this.userConsent.getId().hashCode() : 0;
            result = 31 * result + (this.roleId != null ? this.roleId.hashCode() : 0);
            return result;
        }
    }
}

