/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class CachedResource
extends AbstractRevisioned
implements InResourceServer {
    private String resourceServerId;
    private String iconUri;
    private String owner;
    private String type;
    private String name;
    private String displayName;
    private String uri;
    private Set<String> scopesIds;
    private boolean ownerManagedAccess;

    public CachedResource(Long revision, Resource resource) {
        super(revision, resource.getId());
        this.name = resource.getName();
        this.displayName = resource.getDisplayName();
        this.uri = resource.getUri();
        this.type = resource.getType();
        this.owner = resource.getOwner();
        this.iconUri = resource.getIconUri();
        this.resourceServerId = resource.getResourceServer().getId();
        this.scopesIds = resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
        this.ownerManagedAccess = resource.isOwnerManagedAccess();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    @Override
    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public Set<String> getScopesIds() {
        return this.scopesIds;
    }
}

